<?xml version="1.0" encoding="UTF-8"?>
<!--
    
Oxygen Webhelp plugin
Copyright (c) 1998-2025 Syncro Soft SRL, Romania.  All rights reserved.

-->
<!-- Used to expand Webhelp components that are common to all templates: topic, search, main.  -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:oxy="http://www.oxygenxml.com/functions"
    xmlns:relpath="http://dita2indesign/functions/relpath"
    xmlns:whc="http://www.oxygenxml.com/webhelp/components"
    xmlns:toc="http://www.oxygenxml.com/ns/webhelp/toc"
    xmlns:oxygen="http://www.oxygenxml.com/functions"
    xmlns="http://www.w3.org/1999/xhtml"
    xmlns:html="http://www.w3.org/1999/xhtml"
    xmlns:index="http://www.oxygenxml.com/ns/webhelp/index"
    xmlns:mcr="http://www.oxygenxml.com/ns/webhelp/macro"
    exclude-result-prefixes="#all"
    version="3.0">

    <xsl:include href="macroExpander.xsl"/>
    
    <xsl:param name="FILEDIR"/>
    <xsl:param name="FILENAME"/>
    <xsl:param name="OUTEXT"/>        
    <xsl:param name="TEMPDIR"/>
    <xsl:param name="WEBHELP_TOP_MENU_TEMP_FILE_URL"/>        
    <xsl:param name="DITAMAP_URL"/>
    

    <!-- Map title -->
    <xsl:variable name="mapTitle" as="item()*">
        <xsl:choose>
            <xsl:when test="exists($toc/toc:title) or exists($toc/@title)">
                <xsl:choose>
                    <xsl:when test="$toc/toc:title">
                        <xsl:apply-templates select="$toc/toc:title/node()" mode="copy-xhtml-without-links"/>
                    </xsl:when>
                    <xsl:when test="$toc/@title">
                        <xsl:value-of select="$toc/@title"/>
                    </xsl:when>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>*** Unable to determine the map title</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
     <!-- WebHelp Toc ID for current topic -->
    <xsl:variable name="tocID">
      <xsl:variable name="tocIdFileName">
        <xsl:call-template name="replace-extension">
          <xsl:with-param name="filename" select="$FILENAME"/>
          <xsl:with-param name="extension" select="'.tocid'"/>
          <!-- Remove anchors -->
          <xsl:with-param name="ignore-fragment" select="true()"/>
        </xsl:call-template>
      </xsl:variable>
        
      <xsl:variable name="tocIdFilePath" select="concat($TEMPDIR, '/', $FILEDIR, '/', $tocIdFileName)"/>
      <xsl:variable name="tocIdFileUri" select="string(oxygen:makeURL($tocIdFilePath))"/>       
      <xsl:if test="unparsed-text-available($tocIdFileUri)">
          <xsl:value-of select="normalize-space(unparsed-text($tocIdFileUri))"/>
      </xsl:if>
    </xsl:variable>
    
    <!-- Merge the content of the template head element with the head element generated by DITA-OT -->
    <xsl:template match="html:head" mode="copy_template">
        <xsl:param name="ditaot_topicContent" tunnel="yes" as="node()*"/>
        <xsl:param name="i18n_context" tunnel="yes" as="node()*"/>
        <xsl:copy copy-namespaces="no">
            <!-- EXM-36084 generate linkf for favicon -->
            <xsl:call-template name="generateFaviconLink"/>
            
            <xsl:choose>
                <xsl:when test="exists($ditaot_topicContent)">
                    
                    <!-- head element from dita-ot document -->
                    <xsl:variable name="ditaot_head" select="$ditaot_topicContent//html:head"/>
                    
                    <!-- Merge the attributes from the template head element with attributes from the head element produced by DITA-OT-->
                    <xsl:variable name="mergedAttributes"
                        select="oxy:mergeHTMLAttributes('head', @*, $ditaot_head/@*)"/>
                    <xsl:apply-templates select="$mergedAttributes" mode="copy_template"/>
                    
                    <!-- WH-149 - Copy template head/meta content -->                    
                    <xsl:apply-templates select="*[local-name() eq 'meta']" mode="#current"/>
                    <!-- WH-149 - Copy meta generated by DITA-OT -->
                    <xsl:copy-of select="$ditaot_head/node()[local-name() eq 'meta']"/>
                    
                    <!-- EXM-36084 - Move the custom CSS at end -->
                    <xsl:variable name="customCssLink" as="element()?">
                        <xsl:if test="string-length($CSS) > 0">
                            <xsl:variable name="cssFileName" select="relpath:getName($CSS)"/>
                            <xsl:copy-of select="$ditaot_head/html:link[contains(@href, $cssFileName)]"/>
                        </xsl:if>
                    </xsl:variable>
                    
                    <xsl:copy-of select="$ditaot_head/node()[local-name() eq 'script'][@id='jsonld-faq' or @id='jsonld-howto']"/>
                    
                    <!-- Copy all node from the head element generated by DITA-OT except custom CSS-->
                    <xsl:copy-of select="$ditaot_head/node()[local-name() ne 'link'][local-name() ne 'script'][local-name() ne 'meta']"/>

                    <xsl:call-template name="generatePathToRootMeta"/>
                    <xsl:call-template name="add-toc-id">
                      <xsl:with-param name="tocID" select="$tocID"/>
                    </xsl:call-template>
                    
                    <xsl:call-template name="add-topic-facets">
                      <xsl:with-param name="tocID" select="$tocID" />
                    </xsl:call-template>
                    
                    <!-- 
                    WH-2432 - Generate in the output file a meta element containing the relative path to the topic.
                    -->
                    <xsl:call-template name="generateSourceRelpathMeta">
                        <xsl:with-param name="i18n_context" select="$i18n_context"/>
                    </xsl:call-template>
                    
                    <!-- Copy template head content -->
                    <xsl:apply-templates select="*[local-name() ne 'meta']" mode="#current"/>
                    
                    <!-- 
                        EXM-37429 - Maintain backwards compatibility: Generate links to skin resources 
                        for older templates that do not include the dedicated component.
                    -->
                    <xsl:if test="not(whc:webhelp_skin_resources)">
                        <xsl:call-template name="addLinksToSkinResources"/>
                    </xsl:if>
                    
                    <!-- EXM-36084 - Move custom CSS at end -->
                    <xsl:if test="exists($customCssLink)">                      
                      <xsl:copy-of select="$customCssLink"/>
                    </xsl:if>
                    
                    <xsl:apply-templates select="." mode="gen-user-head-child-elements"/>
                    
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="@*" mode="#current"/>
                    
                    <!-- WH-149 - Copy template meta -->
                    <xsl:apply-templates select="*[local-name() eq 'meta']" mode="#current"/>
                    
                    <xsl:call-template name="generatePathToRootMeta"/>                    
                    
                    <!-- Page title -->
                    <xsl:variable 
                        name="mainBookTitle" 
                        select="$mapTitle[contains(@class, 'booktitle')]/*[contains(@class, 'mainbooktitle')]"/>
                    
                    <xsl:call-template name="generatePageTitle">
                        <xsl:with-param name="mainBookTitle" select="$mainBookTitle"/>
                        <xsl:with-param name="mapTitle" select="$mapTitle"/>
                    </xsl:call-template>
                    
                    <!-- Copy template head content -->
                    <xsl:apply-templates select="node()[local-name() ne 'meta'][local-name() ne 'title']" mode="#current"/>

                    <!-- 
                        EXM-37429 - Maintain backwards compatibility: Generate links to skin resources 
                        for older templates that do not include the dedicated component.
                    -->
                    <xsl:if test="not(whc:webhelp_skin_resources)">
                        <xsl:call-template name="addLinksToSkinResources"/>
                    </xsl:if>
                    
                    <!-- EXM-36084 generate user custom CSS for main page  -->
                    <xsl:call-template name="generateCustomCSSLink"/>
                    
                    <xsl:apply-templates select="." mode="gen-user-head-child-elements"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:copy>
    </xsl:template>
    
    <!--
        Extension template that allows you to generate custom elements within html:head element.
        
        To customize: copy this to your override transform to add custom content in head element.
    -->    
    <xsl:template match="/|node()|@*" mode="gen-user-head-child-elements">
        <!-- DITA topic in HTML format obtained after HTML5 stylesheets were applyed. -->
        <xsl:param name="ditaot_topicContent" tunnel="yes" required="no"/>
    </xsl:template>
    
    <xsl:template name="generatePageTitle">
        <xsl:param name="mainBookTitle"/>
        <xsl:param name="mapTitle"/>
        <title>
            <xsl:variable name="templateTitle" select="*[local-name() eq 'title']"/>
            <xsl:if test="exists($templateTitle)">
                <xsl:value-of select="concat($templateTitle, ' - ')"/>
            </xsl:if>
            <xsl:choose>
                <xsl:when test="exists($mainBookTitle)">
                    <xsl:value-of select="$mainBookTitle"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$mapTitle"/>
                </xsl:otherwise>
            </xsl:choose>
        </title>
    </xsl:template>

    <!--
        Generate a meta element with path to the index.html located in the WH output root.
    -->
    <xsl:template name="generatePathToRootMeta">
        <xsl:choose>            
            <xsl:when test="exists($PATH2PROJ)">                                
                <meta name="wh-path2root" content="{$PATH2PROJ}"/>
            </xsl:when>
            <xsl:otherwise>
                <meta name="wh-path2root" content=""/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>    
    
    <!-- 
        WH-2432 - Generate in the output file a meta element containing the relative path to the topic.
    -->
    <xsl:template name="generateSourceRelpathMeta">
        <xsl:param name="i18n_context"/>
        
        <xsl:variable name="topicXTRF">
            <xsl:choose>
                <xsl:when test="exists($i18n_context/@xtrf)">
                    <xsl:value-of select="$i18n_context/@xtrf"/>                            
                </xsl:when>
                <!-- WH-2457 - For topics with chunk="to-content" -->
                <xsl:when test="exists($i18n_context/*[contains(@class, ' topic/topic ')]/@xtrf)">
                    <xsl:value-of select="$i18n_context/*[contains(@class, ' topic/topic ')]/@xtrf"/>                            
                </xsl:when>
            </xsl:choose>                
        </xsl:variable>
        
        <xsl:choose>
            <xsl:when test="exists($DITAMAP_URL) and exists($i18n_context) and normalize-space($topicXTRF)">
                
                <!-- Make the path relative in the context of the map -->
                <xsl:variable name="relPath"
                    select="
                    relpath:getRelativePath(
                    relpath:getParent($DITAMAP_URL),
                    $topicXTRF)"/>
                
                <!--<xsl:message>relPath: <xsl:copy-of select="$relPath"/></xsl:message>-->
                
                <meta name="wh-source-relpath" content="{$relPath}"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:message>Warning. Cannot generate 'wh-source-relpath' meta information. </xsl:message>
            </xsl:otherwise>
        </xsl:choose>
        
        
        <xsl:variable name="fileNameWitoutExt" select="
            if (substring-after($FILENAME, '.') != '')
                then substring-before($FILENAME, '.')
                else $FILENAME
            "/>
        
        <xsl:variable name="outRelPath" select="
            if ($FILEDIR != '.')
            then concat($FILEDIR, '/', $fileNameWitoutExt, $OUTEXT)
            else concat($fileNameWitoutExt, $OUTEXT)
            "/>        
        <xsl:variable name="outRelPath" select="replace($outRelPath, '\\', '/')"/>
        
        <meta name="wh-out-relpath" content="{$outRelPath}"/>        
    </xsl:template>
    
    
    
    
    <!-- WH-257: Reads the TOC ID from the associated temporary file and adds it as a metadata. -->
    <xsl:template name="add-toc-id">
      <xsl:param name="tocID"/>
      
      <xsl:if test="exists($tocID)">
        <meta name="wh-toc-id" content="{$tocID}"/>
      </xsl:if>
    </xsl:template>
    
    
    <!-- WH-3175: Generates the faces as a meta element. -->
    <xsl:template name="add-topic-facets">
      <xsl:param name="tocID" />
  
      <xsl:if test="exists($tocID)">
        <xsl:apply-templates select="$toc//toc:topic[@wh-toc-id=$tocID]/toc:topicscheme/html:topicsubject" mode="generate-facets" />
      </xsl:if>
    </xsl:template>
    
    <xsl:template match="html:topicsubject" mode="generate-facets">
      <xsl:apply-templates select="html:subjectref/@keyref" mode="#current">
        <xsl:with-param name="facetParent" select="@keyref"/>
      </xsl:apply-templates>        
    </xsl:template>
    
    <xsl:template match="@keyref" mode="generate-facets">
      <xsl:param name="facetParent"/>
      
      <xsl:variable name="facetValue" select="."/>
      <xsl:if test="exists($facetParent) and  
        exists($toc/toc:mapscheme//*[contains(@class, ' subjectScheme/subjectdef ')][@keys=$facetParent]/*[contains(@class, ' subjectScheme/subjectdef ')][@keys=$facetValue])">
        <xsl:variable name="categories">
          <xsl:for-each select="$toc/toc:mapscheme//*[contains(@class, ' subjectScheme/subjectdef ')][@keys=$facetParent]/ancestor-or-self::*[contains(@class, ' subjectScheme/subjectdef ')]/@keys">
            <xsl:value-of select="."/>
            <xsl:if test="position() &lt; last()">
              <xsl:text>/</xsl:text>
            </xsl:if>
          </xsl:for-each>
        </xsl:variable>
          
        <meta name="topic-facet" content="{concat($categories, '/', $facetValue)}" />
          
      </xsl:if>
        
    </xsl:template>
    
    <!-- 
        Expand references to WebHelp libraries.
        The JS and CSS references are stored in HTML Fragment extension files 
        in the plugin's base directory.
    -->
    <xsl:template match="whc:page_libraries[@page]" mode="copy_template">
        <xsl:param name="template_base_uri" tunnel="yes"/>
        <xsl:param name="i18n_context" tunnel="yes" as="element()*"/>
        <!-- [DOT_DIR]\plugins\com.oxygenxml.webhelp.responsive -->
        <xsl:variable name="whPluginDir" select="oxygen:getParameter('webhelp.responsive.dir')"/>
        <xsl:variable name="pageLibRefsDir" select="concat($whPluginDir, '/oxygen-webhelp/page-templates-fragments/libraries/')"/>
        <xsl:variable name="pageLibRefsFileName">
            <xsl:choose>
                <xsl:when test="@page = 'main'">
                    <xsl:value-of select="'main-page-libraries.xml'"/>
                </xsl:when>
                <xsl:when test="@page = 'topic'">
                    <xsl:value-of select="'topic-page-libraries.xml'"/>
                </xsl:when>
                <xsl:when test="@page = 'search'">
                    <xsl:value-of select="'search-page-libraries.xml'"/>
                </xsl:when>
                <xsl:when test="@page = 'indexterms'">
                    <xsl:value-of select="'indexterms-page-libraries.xml'"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:message>Unknown page type <xsl:value-of select="@page"/></xsl:message>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="pageLibraries">
	        <xsl:call-template name="extractFileContent">
	            <xsl:with-param name="href" select="concat($pageLibRefsDir, $pageLibRefsFileName)"/>
	            <xsl:with-param name="template_base_uri" select="$template_base_uri"/>
	        </xsl:call-template>
        </xsl:variable>
        
        
        <xsl:choose>
        	<xsl:when test="oxygen:getParameter('webhelp.custom.search.engine.enabled') = 'true'">
       			<xsl:apply-templates select="$pageLibraries" mode="remove-search-scripts" />
        	</xsl:when>
        	<xsl:otherwise>
        		<xsl:copy-of select="$pageLibraries" />
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
    <!-- Remove the scripts from page libraries that are specific for search. -->
    <xsl:template match="html:script[contains(@src, 'app/search/')]" mode="remove-search-scripts" />
  
    <xsl:template match="node() | @*" mode="remove-search-scripts">
        <xsl:copy>
            <xsl:apply-templates select="node() | @*" mode="#current"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- Generate links to CSSs and JavaScript that are custom to all Responsive pages. -->
    <xsl:template match="whc:webhelp_skin_resources" mode="copy_template">
        <xsl:call-template name="addLinksToSkinResources"/>
    </xsl:template>
    <xsl:template name="addLinksToSkinResources">
        <xsl:variable name="cssResources" select="oxygen:getParameter('webhelp.responsive.custom.template.skin.relpath')"/>
        <xsl:choose>
            <!-- WH-1448 Relative path to CSS specified by the custom template -->
            <xsl:when test="string-length($cssResources) > 0">
                <xsl:variable name="cssResList" select="tokenize($cssResources, ';')"/>
                <xsl:for-each select="$cssResList">
                    <link rel="stylesheet" type="text/css" href="{
                        concat($PATH2PROJ,
                        'oxygen-webhelp/template/',
                        .,
                        '?buildId=', 
                        $WEBHELP_BUILD_NUMBER)
                        }"/>                    
                </xsl:for-each>                
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="webhelp_skin_css_name">
                    <xsl:choose>
                        <xsl:when test="string-length(oxygen:getParameter('webhelp.responsive.custom.skin')) > 0">
                            <xsl:value-of select="'custom'"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="oxygen:getParameter('webhelp.responsive.skin.name')"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                
                <link rel="stylesheet" type="text/css" href="{
                    concat($PATH2PROJ,
                    'oxygen-webhelp/template/variants/',
                    oxygen:getParameter('webhelp.responsive.variant.name'),
                    '/',
                    $webhelp_skin_css_name,
                    '/skin.css?buildId=', 
                    $WEBHELP_BUILD_NUMBER)
                    }"/>
            </xsl:otherwise>
        </xsl:choose>        
    </xsl:template>
    
    <!-- 
        Expand the 'webhelp_search_input' place holder. 
    -->
    <xsl:template match="whc:webhelp_search_input" mode="copy_template">
        <!-- EXM-36737 - Context node used for messages localization -->
        <xsl:param name="i18n_context" tunnel="yes" as="element()*"/>
        <div>
            <xsl:call-template name="generateComponentClassAttribute">
                <xsl:with-param name="compClass">wh_search_input</xsl:with-param>
            </xsl:call-template>
            <!-- Copy attributes -->
            <xsl:copy-of select="@* except @class"/>
            
            <xsl:variable name="localizedSearch">
                <xsl:choose>
                    <xsl:when test="exists($i18n_context)">
                        <xsl:for-each select="$i18n_context[1]">
                            <xsl:call-template name="getWebhelpString">
                                <xsl:with-param name="stringName" select="'webhelp.search'"/>
                            </xsl:call-template>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>Search</xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            <xsl:variable name="localizedSearchQuery">
                <xsl:choose>
                    <xsl:when test="exists($i18n_context)">
                        <xsl:for-each select="$i18n_context[1]">
                            <xsl:call-template name="getWebhelpString">
                                <xsl:with-param name="stringName" select="'search.query'"/>
                            </xsl:call-template>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>Search query</xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            
            <xsl:variable name="search_comp_output">
                        <form id="searchForm"
                            method="get"
                            role="search"                            
                            action="{concat($PATH2PROJ, 'search', $OUTEXT)}">
                            <div>
                                <input type="search" placeholder="{$localizedSearch} " class="wh_search_textfield"
                                    id="textToSearch" name="searchQuery" aria-label="{$localizedSearchQuery}" required="required"/>
                                <button type="submit" class="wh_search_button" aria-label="{$localizedSearch}"><span class="search_input_text"><xsl:value-of select="$localizedSearch"/></span></button>
                            </div>
                        </form>
            </xsl:variable>
            
            <xsl:call-template name="outputComponentContent">
                <xsl:with-param name="compContent" select="$search_comp_output"/>
                <xsl:with-param name="compName" select="local-name()"/>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    <!--
        Template used to emit the component content. 
        It is aware if the a place holder is set for its content, whc:component_content.
    -->
    <xsl:template name="outputComponentContent">
        <xsl:param name="compContent"/>
        <xsl:param name="compName"/>
        
        <xsl:choose>
            <xsl:when test="count(*) = 0">
                <!-- The component has no children. Output its content -->
                <xsl:copy-of select="$compContent"/>
            </xsl:when>
            <xsl:when test="descendant::whc:component_content[ancestor::whc:*[1][local-name() = $compName]]">
                <!-- The component has set a place holder where to emit the content -->
                <xsl:apply-templates mode="#current">
                    <xsl:with-param name="compContent" select="$compContent" tunnel="yes"/>
                </xsl:apply-templates>
            </xsl:when>
            <xsl:otherwise>
                <!-- 
                    There is no place holder for the content content. So, emit it here 
                -->
                <xsl:copy-of select="$compContent"/> 
                <xsl:apply-templates mode="#current"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!--
        Emit the component content.
    -->
    <xsl:template match="whc:component_content" mode="copy_template">
        <xsl:param name="compContent" tunnel="yes"/>
        <xsl:if test="exists($compContent)">
            <xsl:copy-of select="$compContent"/>            
        </xsl:if>
    </xsl:template>
    
    <!--
        WebHelp logo component
    -->
    <xsl:template match="whc:webhelp_logo" mode="copy_template">
        <xsl:if test="string-length($WEBHELP_LOGO_IMAGE) > 0">
        
            <!-- If the target of the logo is not specified, use the relative path to the index.html page. -->
            <xsl:variable name="href">
                <xsl:choose>
                    <xsl:when test="$WEBHELP_LOGO_IMAGE_TARGET_URL"><xsl:value-of select="$WEBHELP_LOGO_IMAGE_TARGET_URL"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="concat($PATH2PROJ, 'index', $OUTEXT)"/></xsl:otherwise>                
                </xsl:choose>
            </xsl:variable>
            <xsl:variable name="altText">
                <xsl:variable name="logoAltParam" select="oxygen:getParameter('webhelp.logo.image.alt')"/>
                <xsl:choose>
                    <xsl:when test="string-length($logoAltParam) > 0">
                        <xsl:value-of select="$logoAltParam"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$mapTitle"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            <xsl:variable name="logoComp">
                <a href="{$href}">          
                    <xsl:call-template name="generateComponentClassAttribute">
                        <xsl:with-param name="compClass">wh_logo</xsl:with-param>
                    </xsl:call-template>
                    <!-- Copy attributes -->
                    <xsl:copy-of select="@* except @class"/>
                    <xsl:if test="$WEBHELP_LOGO_IMAGE_TARGET_URL_NEW_TAB = 'yes'">
                        <xsl:attribute name="target" select="'_blank'"/>
                        <xsl:attribute name="rel" select="'noopener'"/>
                    </xsl:if>
                    
                    <xsl:choose>
                       <xsl:when test="string-length($WEBHELP_LOGO_IMAGE) > 0 
                           and contains($WEBHELP_LOGO_IMAGE, ':/')">
                           <img src="{$WEBHELP_LOGO_IMAGE}" alt="{$altText}"/>
                        </xsl:when>
                    
                        <xsl:when
                           test="string-length($WEBHELP_LOGO_IMAGE) > 0">
                           <img src="{concat($PATH2PROJ, $WEBHELP_LOGO_IMAGE)}" alt="{$altText}"/>
                        </xsl:when>
                    </xsl:choose>        
                </a>
            </xsl:variable>
           
            <xsl:call-template name="outputComponentContent">
                <xsl:with-param name="compContent" select="$logoComp"/>
                <xsl:with-param name="compName" select="local-name()"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    
    <!-- 
        Expand 'webhelp_publication_title' place holder. 
    -->                     
    <xsl:template match="whc:webhelp_publication_title" mode="copy_template">
        <!-- If true then generate link to main page when generate the product title -->
        <xsl:variable name="publication_title">
            <div>
                <xsl:call-template name="generateComponentClassAttribute">
                    <xsl:with-param name="compClass">wh_publication_title</xsl:with-param>
                </xsl:call-template>
                <!-- Copy attributes -->
                <xsl:copy-of select="@* except @class"/>
                
                <xsl:choose>
                    <xsl:when test="exists($mapTitle)">
                        <xsl:choose>
                            <xsl:when test="exists($PATH2PROJ)">                                
                                <a href="{concat($PATH2PROJ,'index', $OUTEXT)}">
                                    <xsl:copy-of select="$mapTitle"/>
                                </a>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:copy-of select="$mapTitle"/>
                            </xsl:otherwise>
                        </xsl:choose>
                        
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:message>Warn: Cannot get the map title.</xsl:message>
                    </xsl:otherwise>
                </xsl:choose>
            </div>
        </xsl:variable>
        
        <xsl:call-template name="outputComponentContent">
            <xsl:with-param name="compContent" select="$publication_title"/>
            <xsl:with-param name="compName" select="local-name()"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- External resource link -->
    <xsl:template match="whc:external_resourse_link[@type='pdf_link']" mode="copy_template">
        
        <xsl:param name="ditaot_topicContent" tunnel="yes"/>
        
        <xsl:variable name="showPdfLink" 
            select="oxy:getParameter('webhelp.show.pdf.link') = 'yes' and
            string-length(oxy:getParameter('webhelp.pdf.link.url')) > 0 and
            string-length(oxy:getParameter('webhelp.pdf.link.text')) > 0"
            as="xs:boolean"/>
        
        <xsl:if test="$showPdfLink" >
            
            <a target="_blank" >
                <xsl:attribute name="href" >
                    <xsl:variable name="url">
                        <xsl:value-of>
                            <xsl:apply-templates select="@href" mode="copy_template"/>
                        </xsl:value-of>
                    </xsl:variable>
                    
                    <xsl:variable name="pdfLinkContext">
                        <xsl:if test="oxy:getParameter('webhelp.pdf.link.name.destination.enabled') = 'yes' and exists($ditaot_topicContent)">
                            <xsl:value-of select="$ditaot_topicContent//*:head/*:meta[@name='DC.identifier']/@content"/>
                        </xsl:if>
                    </xsl:variable>
                    
                    <xsl:choose>
                        <xsl:when test="string-length($pdfLinkContext) > 0">
                            <xsl:value-of select="concat($url, '#', $pdfLinkContext)"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$url"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute>
                <xsl:variable name="linkText">
                    <xsl:value-of>
                        <xsl:apply-templates select="@title" mode="copy_template"/>
                    </xsl:value-of>
                </xsl:variable>
                <xsl:attribute name="title" select="$linkText"/>
                <xsl:attribute name="aria-label" select="$linkText"/>   
                <xsl:attribute name="rel">noopener</xsl:attribute>
                
                <xsl:call-template name="generateComponentClassAttribute">
                    <xsl:with-param name="compClass">wh_external_resourse_link <xsl:value-of select="@type"/></xsl:with-param>
                </xsl:call-template>
                
                <xsl:variable name="imageUrl">
                    <xsl:value-of>
                        <xsl:apply-templates select="@image" mode="copy_template"/>
                    </xsl:value-of>
                </xsl:variable>
                <xsl:choose>
                    <xsl:when test="string-length($imageUrl) > 0">
                        <img src="{$imageUrl}"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <span class="oxy-icon oxy-icon-pdf-link"/>
                    </xsl:otherwise>
                </xsl:choose>
            </a>
        </xsl:if>
    </xsl:template>
    
    
    <!-- Utility functions -->
    <!-- 
        Merge two sequences of HTML attributes. 
        If class or style attributes are present in both sequences then the value of these attributes is merged.   
    -->
    <xsl:function name="oxy:mergeHTMLAttributes" as="attribute()*">
        <xsl:param name="parentElementName" as="xs:string"/>
        <xsl:param name="templateAttributes" as="attribute()*"/>
        <xsl:param name="ditaotAttributes" as="attribute()*"/>
        
        <xsl:choose>
            <xsl:when test="empty($templateAttributes)">
                <xsl:copy-of select="$ditaotAttributes"/>
            </xsl:when>
            
            <xsl:when test="empty($ditaotAttributes)">
                <xsl:copy-of select="$templateAttributes"/>
            </xsl:when>
            
            <xsl:otherwise>
                <xsl:variable name="mergedAttributes" as="attribute()*">
                    <xsl:for-each select="$templateAttributes">
                        <!-- Test if the attribute is also included in the DITA-OT element. -->
                        <xsl:variable name="cAttrName" select="name(.)"/>
                        
                        <xsl:variable name="ditaotAttr"
                            select="$ditaotAttributes[name() = $cAttrName]" as="attribute()*"/>
                        <xsl:choose>
                            <xsl:when test="exists($ditaotAttr)">                                
                                <xsl:choose>
                                    <!-- Union the value of class attributes -->
                                    <xsl:when test="$cAttrName = 'class'">
                                        <xsl:variable name="newClassAttr" select="concat(., ' ', $ditaotAttr)"/>
                                        <xsl:attribute 
                                            name="{$cAttrName}" 
                                            select="$newClassAttr"/>                                            
                                    </xsl:when>
                                    
                                    <!-- Union the value of style attributes -->
                                    <xsl:when test="$cAttrName = 'style'">
                                        <xsl:attribute name="{$cAttrName}" select="concat(., ';', $ditaotAttr)"/>
                                    </xsl:when>
                                    
                                    <!-- Prefer the ID from the template -->
                                    <xsl:when test="$cAttrName = 'id'">
                                        <xsl:copy-of select="."/>                                        
                                    </xsl:when>
                                    
                                    <xsl:otherwise>
                                        <xsl:copy/>
                                        <xsl:message> Warning: The attribute <xsl:value-of
                                            select="$cAttrName"/> is present on '<xsl:value-of
                                                select="$parentElementName"/>' element in template
                                            HTML document and in the HTML document generated by
                                            DITA-OT. </xsl:message>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:copy/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:for-each>
                </xsl:variable>
                <xsl:sequence select="($ditaotAttributes except $templateAttributes)[every $attr in $mergedAttributes satisfies name($attr) ne name()] union $mergedAttributes"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>
    
    <xsl:template match="node() | @*" mode="copy_template">
        <xsl:copy copy-namespaces="no">
            <xsl:apply-templates select="node() | @*" mode="#current"/>
        </xsl:copy>
    </xsl:template>
    
    
    <!-- WH-176: Copy the menu button for mobile devices only when the 'webhelp.show.top.menu' parameter is set to 'yes' -->
    <xsl:template match="*:button[@id='wh_menu_mobile_button']" mode="copy_template">
        <xsl:if test="oxy:getParameter('webhelp.show.top.menu') = 'yes'">
            <xsl:copy copy-namespaces="no">
                <xsl:apply-templates select="node() | @*" mode="#current"/>
            </xsl:copy>
        </xsl:if>
    </xsl:template>
    
    
    <!-- 
        Templates for 'create-topics-menu' mode are used to generate the menu
    -->
    <xsl:template match="whc:webhelp_top_menu" mode="copy_template">
        <xsl:if test="oxy:getParameter('webhelp.show.top.menu') = 'yes'">
            <xsl:variable name="top_menu">
                <nav>
                    <xsl:call-template name="generateComponentClassAttribute">
                        <xsl:with-param name="compClass">
                            <xsl:choose>
                                <xsl:when test="oxygen:getParameter('webhelp.top.menu.activated.on.click') = 'yes'">
                                    <xsl:value-of>wh_top_menu activated-on-click</xsl:value-of>
                                </xsl:when>
                                <xsl:otherwise>wh_top_menu</xsl:otherwise>
                            </xsl:choose>
                            </xsl:with-param>
                    </xsl:call-template>
                    <xsl:attribute name="aria-label">Menu Container</xsl:attribute>
                    <xsl:copy-of select="@* except @class"/>
                    <xsl:choose>
                        <xsl:when test="string-length($WEBHELP_TOP_MENU_TEMP_FILE_URL) > 0 and doc-available($WEBHELP_TOP_MENU_TEMP_FILE_URL)">
                            <xsl:variable name="top-menu" select="doc($WEBHELP_TOP_MENU_TEMP_FILE_URL)"/>
                            <xsl:apply-templates select="$top-menu" mode="copy-top-menu"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <!-- The entire message should be output on a single line in order to be presented in the Results View. -->
                            <xsl:message>[OXYWH003W][WARN] Cannot read the top menu content from file: '<xsl:value-of select="$WEBHELP_TOP_MENU_TEMP_FILE_URL"/>'.</xsl:message>
                        </xsl:otherwise>
                    </xsl:choose>
                </nav>
            </xsl:variable>
            
            <xsl:call-template name="outputComponentContent">
                <xsl:with-param name="compContent" select="$top_menu"/>
                <xsl:with-param name="compName" select="local-name()"/>
            </xsl:call-template>
        </xsl:if>
        
    </xsl:template>
    
    <!-- Copy template. -->
    <xsl:template match="node() | @*" mode="copy-top-menu">
        <xsl:copy>
            <xsl:apply-templates select="node() | @* except @data-scope" mode="copy-top-menu"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- 
        Update the Menu links to be relative to the current topic.
        Currently they are stored relative to the output directory.
        
        Avoid external references.
    -->
    <xsl:template match="*:a[@href][not(@data-scope='external' or @data-scope='peer')]" mode="copy-top-menu">
        <xsl:copy>
            <xsl:attribute name="href" select="concat($PATH2PROJ, @href)"/>
            <xsl:apply-templates select="node() | @* except @href" mode="copy-top-menu"/>
        </xsl:copy>
    </xsl:template>
    <xsl:template match="*:img[@src][not(@data-scope='external' or @data-scope='peer')]" mode="copy-top-menu">
        <xsl:copy>
            <xsl:attribute name="src" select="concat($PATH2PROJ, @src)"/>
            <xsl:apply-templates select="node() | @* except @src" mode="copy-top-menu"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- 
        Expand the 'webhelp_indexterms_link' to a link to the indexterms.html page.
    -->
    <xsl:template match="whc:webhelp_indexterms_link" mode="copy_template">
      <!-- EXM-36737 - Context node used for messages localization -->
      <xsl:param name="i18n_context" tunnel="yes" as="element()*"/>
      
        <xsl:if test="oxy:getParameter('webhelp.show.indexterms.link') = 'yes'">
            <xsl:if test="oxygen:getParameter('indexterms.available') = 'true'">              
                <xsl:variable name="placeHolderText">
                  <xsl:choose>
                    <xsl:when test="exists($i18n_context)">
                      <xsl:for-each select="$i18n_context[1]">
                        <xsl:call-template name="getWebhelpString">
                          <xsl:with-param name="stringName" select="'webhelp.index'"/>
                        </xsl:call-template>
                      </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>Index</xsl:otherwise>
                  </xsl:choose>
                </xsl:variable>
                
                <xsl:variable name="ariaLabelText">
                    <xsl:choose>
                        <xsl:when test="exists($i18n_context)">
                            <xsl:for-each select="$i18n_context[1]">
                                <xsl:call-template name="getWebhelpString">
                                    <xsl:with-param name="stringName" select="'webhelp.index.aria.label'"/>
                                </xsl:call-template>
                            </xsl:for-each>
                        </xsl:when>
                        <xsl:otherwise>Go to index terms page</xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                
                <xsl:variable name="indexterms_link">
                    <div>
                        <xsl:call-template name="generateComponentClassAttribute">
                            <xsl:with-param name="compClass">wh_indexterms_link</xsl:with-param>                
                        </xsl:call-template>
                        <xsl:copy-of select="@* except @class"/>                        
                        <a href="{concat($PATH2PROJ, 'indexTerms', $OUTEXT)}" title="{$placeHolderText}" aria-label="{$ariaLabelText}"><span><xsl:value-of select="$placeHolderText"/></span></a>            
                    </div>        
                </xsl:variable>
                
                <xsl:call-template name="outputComponentContent">
                    <xsl:with-param name="compContent" select="$indexterms_link"/>
                    <xsl:with-param name="compName" select="local-name()"/>
                </xsl:call-template>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    
    <!-- Generate the class attribute for a WH component. -->
    <xsl:template name="generateComponentClassAttribute">
        <xsl:param name="compClass"/>
        <xsl:choose>
            <xsl:when test="@class">
                <xsl:variable name="classFromTemplate" as="attribute()*">
                    <xsl:apply-templates select="@class" mode="copy_template"/>
                </xsl:variable>
                <xsl:attribute name="class" select="concat(' ', $compClass, ' ', string($classFromTemplate), ' ')"/>
                
                <xsl:apply-templates select="@* except @class" mode="#current"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="class" select="concat(' ', $compClass, ' ')"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!--
        Template used to generate the image for a menu item. 
    -->
    <xsl:template name="generateMenuItemImage">
        <xsl:param name="title"/>
        <xsl:param name="cTopic"/>
        
        <xsl:variable 
            name="dataImage" 
            select="$cTopic/toc:topicmeta/toc:data[@name='wh-menu']/toc:data[@name='image'][@href]"/>
        
        <xsl:if test="$dataImage">
            <span class="topicImg">                                
                <img src="{concat($PATH2PROJ, $dataImage/@href)}" alt="{$title}">
                    <xsl:variable name="attrWidth" select="$dataImage/toc:data[@name = 'attr-width'][@value]"/>
                    <xsl:if test="$attrWidth">
                        <xsl:attribute name="width" select="$attrWidth/@value"/>
                    </xsl:if>
                    
                    <xsl:variable name="attrHeight" select="$dataImage/toc:data[@name = 'attr-height'][@value]"/>
                    <xsl:if test="$attrHeight">
                        <xsl:attribute name="height" select="$attrHeight/@value"/>
                    </xsl:if>
                </img>
            </span>
        </xsl:if>
    </xsl:template>
    
    
    
    <!-- Expand 'include_html' component. -->
    <xsl:template match="whc:include_html[@href]" mode="copy_template create-tiles">
        <xsl:param name="template_base_uri" tunnel="yes"/>
        <xsl:param name="i18n_context" tunnel="yes" as="element()*"/>
        <xsl:choose>
            <xsl:when test="contains(@href, '${webhelp.fragment.footer}') and $WEBHELP_TRIAL_LICENSE = 'yes'">
                <xsl:text>Generated by </xsl:text>
                <a class="oxyFooter" href="http://www.oxygenxml.com/xml_webhelp.html" target="_blank" rel="noopener">
                	<xsl:text>&lt;oXygen/&gt; XML WebHelp</xsl:text>
                </a><xsl:text> - Evaluation Version</xsl:text>                
            </xsl:when>
            <!-- WH-2696 Default footer fragment-->
            <xsl:when test="contains(@href, '${webhelp.fragment.footer}') and oxygen:getParameter('webhelp.fragment.footer') = ''">
                <xsl:variable name="whPluginDir" select="oxygen:getParameter('webhelp.responsive.dir')"/>
                <xsl:variable name="footerDir" select="concat($whPluginDir, '/oxygen-webhelp/page-templates-fragments/footer/')"/>
                <xsl:call-template name="extractFileContent">
                    <xsl:with-param name="href" select="concat($footerDir, 'webhelp-footer.xml')"/>
                    <xsl:with-param name="template_base_uri" select="$template_base_uri"/>
                </xsl:call-template>            
            </xsl:when>
            <!-- WH-3144 Fixup for the feedback fragment -->
            <xsl:when test="contains(@href, '${webhelp.fragment.feedback}')">
                <xsl:variable name="feedback-fragment">
                  <xsl:call-template name="extractFileContent">
                      <xsl:with-param name="href">
                          <xsl:call-template name="expand-macros">
                              <xsl:with-param name="value" select="@href"/>
                              <xsl:with-param name="contextNode" select="@href"/>
                              <xsl:with-param name="i18n_context" select="$i18n_context"/>
                          </xsl:call-template>
                      </xsl:with-param>
                      <xsl:with-param name="template_base_uri" select="$template_base_uri"/>
                  </xsl:call-template>        
                </xsl:variable>
                <xsl:apply-templates select="$feedback-fragment" mode="feedback-defer-attribute-fixup" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="extractFileContent">
                    <xsl:with-param name="href">
                        <xsl:call-template name="expand-macros">
                            <xsl:with-param name="value" select="@href"/>
                            <xsl:with-param name="contextNode" select="@href"/>
                            <xsl:with-param name="i18n_context" select="$i18n_context"/>
                        </xsl:call-template>
                    </xsl:with-param>
                    <xsl:with-param name="template_base_uri" select="$template_base_uri"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- Add defer attribute on script element if it does not exist. -->
    <xsl:template match="html:script[not(@defer)]" mode="feedback-defer-attribute-fixup">
      <xsl:copy>
        <xsl:attribute name="defer">defer</xsl:attribute>
        <xsl:apply-templates select="@* | node()" mode="#current" />
      </xsl:copy>
    </xsl:template>
  
    <xsl:template match="node() | @*" mode="feedback-defer-attribute-fixup">
        <xsl:copy>
            <xsl:apply-templates select="node() | @*" mode="#current"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- Template used to extract the content of a file passed as parameter -->
    <xsl:template name="extractFileContent">
      <xsl:param name="href"/>
      <xsl:param name="template_base_uri"/>
    
      <xsl:if test="string-length(normalize-space($href)) != 0">
      <!-- Convert to URL -->
      <xsl:choose>
        <xsl:when test="doc-available(relpath:toUrl($href))">
          <!-- It is an URL -->            
          <xsl:call-template name="includeCustomHTMLContent">
            <xsl:with-param name="hrefURL" select="$href"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>            
                                
            <!-- WH-208 [WH-Responsive] - Use whc:include_html for header and footer -->
            <xsl:choose>
                <!-- Skip URLs that contains ' ' -->
                <xsl:when test="not(contains($href, ' '))">
                    <!-- Try with relative path -->
                    <xsl:variable name="relURL" select="resolve-uri(iri-to-uri($href), $template_base_uri)"/>
                    <xsl:choose>
                        <xsl:when test="(doc-available($relURL))">
                            <!-- Relative URL to template -->            
                            <xsl:call-template name="includeCustomHTMLContent">
                                <xsl:with-param name="hrefURL" select="$relURL"/>
                            </xsl:call-template>
                        </xsl:when>
                        <xsl:otherwise>
                            <!-- The href is in fact an inline XML fragment. Parse it and copy the nodes to the output -->
                            <xsl:copy-of select="oxygen:parse-xml-fragment($href)"/>
                        </xsl:otherwise>
                    </xsl:choose>                    
                </xsl:when>
                <xsl:otherwise>
                    <!-- The href is in fact an inline XML fragment. Parse it and copy the nodes to the output -->
                    <xsl:copy-of select="oxygen:parse-xml-fragment($href)"/>
                </xsl:otherwise>
            </xsl:choose>   
        
            
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:template>
    
    <!--
    Include in the output an HTML fragment. It is used to extand webhelp.fragment parameters. 
  -->
    <xsl:template name="includeCustomHTMLContent">
        <xsl:param name="hrefURL"/>
        
        <xsl:variable name="content" select="doc(relpath:toUrl($hrefURL))"/>
        <xsl:variable name="selectedNodes">
            <xsl:choose>
                <xsl:when test="$content/*:html/*:head or $content/*:html/*:body">
                    <xsl:copy-of select="$content/*:html/*:head/node()"/>
                    <xsl:copy-of select="$content/*:html/*:body/node()"/>
                </xsl:when>
                <xsl:when test="$content/*:head or $content/*:body">
                    <xsl:copy-of select="$content/*:head/node()"/>
                    <xsl:copy-of select="$content/*:body/node()"/>
                </xsl:when>
                <xsl:when test="$content/*:html">
                    <xsl:copy-of select="$content/*:html/node()"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:copy-of select="$content"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <!-- Apply templates in 'copy_template' mode to expand macros -->
        <xsl:variable name="expanded">
            <xsl:apply-templates select="$selectedNodes" mode="fixup_XHTML_NS"/>
        </xsl:variable>
        <xsl:apply-templates select="$expanded" mode="copy_template"/>
    </xsl:template>

    <xsl:template match="whc:*" priority="-10">
        <xsl:message>Component not processed: <xsl:copy-of select="."></xsl:copy-of></xsl:message>
    </xsl:template>
  
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Test if a parameter is specified or not.</xd:p>
        </xd:desc>
        <xd:param name="parameterName">The name of the parameter.</xd:param>
    </xd:doc>
    <xsl:function name="oxygen:isParameterSpecified" as="xs:boolean">
        <xsl:param name="parameterName"/>
        
        <xsl:sequence select="
            if (exists($plugin.declared.parameters/property[@name=$parameterName]/@value)) 
                then true() 
                else false()"/>
    </xsl:function>
   
    <xsl:template match="whc:*" mode="copy_template" priority="-10"/>
    
    <!-- Function used to test if a topic will be included in the menu -->
    <xsl:function name="oxygen:shouldDisplayMenuItem" as="xs:boolean">
        <xsl:param name="cTopic"/>
        
        <xsl:sequence select="not($cTopic/toc:topicmeta/toc:data[@name='wh-menu']/toc:data[@name='hide']/@value = 'yes')"/>
    </xsl:function>
    
    <!-- Generate link to custom CSS -->
    <xsl:template name="generateCustomCSSLink">
        <xsl:if test="string-length($CSS) > 0">
            <xsl:variable name="urltest">
                <!-- test for URL -->
                <xsl:call-template name="url-string-oxy-internal">
                    <xsl:with-param name="urltext">
                        <xsl:value-of select="concat($CSSPATH, $CSS)"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:variable>
            <xsl:choose>
                <xsl:when test="$urltest = 'url'">
                    <link rel="stylesheet" type="text/css" href="{$CSSPATH}{$CSS}"
                        data-css-role="args.css">
                        <xsl:comment/>
                    </link>
                </xsl:when>
                <xsl:otherwise>
                    <link rel="stylesheet" type="text/css" href="{$PATH2PROJ}{$CSSPATH}{$CSS}"
                        data-css-role="args.css">
                        <xsl:comment/>
                    </link>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    
    <!-- Generate link to favicon -->
    <xsl:template name="generateFaviconLink">
        <xsl:if test="string-length($WEBHELP_FAVICON) > 0">            
            <xsl:variable name="favIconPath" select="concat($PATH2PROJ, $WEBHELP_FAVICON)"/>
            <link rel="shortcut icon">
                <xsl:attribute name="href">
                    <xsl:value-of select="$favIconPath"/>
                </xsl:attribute>
            </link>
            <link rel="icon">
                <xsl:attribute name="href">
                    <xsl:value-of select="$favIconPath"/>
                </xsl:attribute>
            </link>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="url-string-oxy-internal">
        <xsl:param name="urltext"/>
        <xsl:choose>
            <xsl:when test="contains($urltext, 'http://')">url</xsl:when>
            <xsl:when test="contains($urltext, 'https://')">url</xsl:when>
            <xsl:otherwise/>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="@whc:version" mode="copy_template">
    	<xsl:attribute name="data-whc_version">
    		<xsl:value-of select="."/>
    	</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="*" mode="copy-xhtml copy-xhtml-without-links">
        <xsl:element name="{local-name()}" namespace="{namespace-uri()}">
            <xsl:apply-templates select="@* | node()" mode="#current"/>
        </xsl:element>
    </xsl:template>
    
    <xsl:template match="@*" mode="copy-xhtml copy-xhtml-without-links">
        <xsl:attribute name="{local-name()}" select="."/>
    </xsl:template>
    
    <!-- Skip HTML 'a' elements from output -->
    <xsl:template match="*:a" mode="copy-xhtml-without-links">
        <xsl:apply-templates select="node()" mode="#current"/>
    </xsl:template>
    
</xsl:stylesheet>