<?xml version="1.0" encoding="UTF-8"?>
<!--
    
Oxygen Webhelp plugin
Copyright (c) 1998-2025 Syncro Soft SRL, Romania.  All rights reserved.

-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:toc="http://www.oxygenxml.com/ns/webhelp/toc"
  xmlns:index="http://www.oxygenxml.com/ns/webhelp/index"   
  xmlns:oxygen="http://www.oxygenxml.com/functions" xmlns:d="http://docbook.org/ns/docbook"
  xmlns:whc="http://www.oxygenxml.com/webhelp/components" xmlns="http://www.w3.org/1999/xhtml"
  xmlns:html="http://www.w3.org/1999/xhtml"
  xmlns:xs="http://www.w3.org/2001/XMLSchema" 
  exclude-result-prefixes="#all" version="3.0">
  
  <!-- Used to expand common WebHelp components like menu -->
  <xsl:import href="../template/commonComponentsExpander.xsl"/>
  
  <!-- Localization of text strings displayed in Webhelp output. -->
  <xsl:import href="../util/dita-utilities.xsl"/> 
  <xsl:import href="../util/functions.xsl"/>
  
  <!-- XSLT library to work with paths -->
  <xsl:import href="../util/relpath_util.xsl"/>  
  <xsl:import href="../util/fixupNS.xsl"/>
    
  <!-- Declares all available parameters -->
  <xsl:include href="params.xsl"/>
  
  <xsl:output 
    method="xhtml" 
    html-version="5.0"
    encoding="UTF-8"
    indent="no"
    omit-xml-declaration="yes"
    include-content-type="no"/>
  
  <!-- EXM-36947 Used to translate katakana chars to hiragana when grouping index terms. -->
  <!-- アカサタナハマヤラワイキシチニヒミリヰウクスツヌフムユルエケセテネヘメレヱオコソトノホモヨロヲ -->
  <xsl:variable 
    name="katakana_chars"
    select="'&#12450;&#12459;&#12469;&#12479;&#12490;&#12495;&#12510;&#12516;&#12521;&#12527;&#12452;&#12461;&#12471;&#12481;&#12491;&#12498;&#12511;&#12522;&#12528;&#12454;&#12463;&#12473;&#12484;&#12492;&#12501;&#12512;&#12518;&#12523;&#12456;&#12465;&#12475;&#12486;&#12493;&#12504;&#12513;&#12524;&#12529;&#12458;&#12467;&#12477;&#12488;&#12494;&#12507;&#12514;&#12520;&#12525;&#12530;'"/>
  
  <!-- あかさたなはまやらわいきしちにひみりゐうくすつぬふむゆるえけせてねへめれゑおこそとのほもよろを -->
  <xsl:variable 
    name="hiragana_chars"
    select="'&#12354;&#12363;&#12373;&#12383;&#12394;&#12399;&#12414;&#12420;&#12425;&#12431;&#12356;&#12365;&#12375;&#12385;&#12395;&#12402;&#12415;&#12426;&#12432;&#12358;&#12367;&#12377;&#12388;&#12396;&#12405;&#12416;&#12422;&#12427;&#12360;&#12369;&#12379;&#12390;&#12397;&#12408;&#12417;&#12428;&#12433;&#12362;&#12371;&#12381;&#12392;&#12398;&#12411;&#12418;&#12424;&#12429;&#12434;'"/>  
  
  <!-- Loads the additional XML documents. -->
  <xsl:variable name="index" select="document(oxygen:makeURL($INDEX_XML_FILEPATH), .)/index:index"/>    
  <xsl:variable name="toc" select="document(oxygen:makeURL($TOC_XML_FILEPATH), .)/toc:toc"/>
  
  <!--
    A temporary node used to keep @lang and @dir attributes.
  -->
  
  <xsl:variable name="webhelp_language" select="oxygen:getParameter('webhelp.language')"/>
  
  <xsl:variable name="i18n_context">
    <i18n_context>
      <xsl:attribute name="xml:lang" select="$webhelp_language"/>
      <xsl:attribute name="lang" select="$webhelp_language"/>
      <xsl:attribute name="dir" select="oxygen:getParameter('webhelp.page.direction')"/>
    </i18n_context>
  </xsl:variable>
  
  <!-- 
    Creates the index terms file using the given template.
  -->
  <xsl:template match="/">
    <xsl:variable name="template_base_uri" select="base-uri()"/>
    <!-- Expand the components index terms template -->    
    <xsl:apply-templates mode="copy_template">
      <!-- EXM-36737 - Context node used for messages localization -->
      <xsl:with-param name="i18n_context" select="$i18n_context/*" tunnel="yes" as="element()"/>
      <xsl:with-param name="template_base_uri" select="$template_base_uri" tunnel="yes"/>
    </xsl:apply-templates>
    
  </xsl:template>

  <!-- 
    Generate the index terms grouped by the first letter.
  -->
  <xsl:template match="index:index" mode="create-index">
    
    <!-- EXM-36947 - Use a collation to support multi language sort -->
    <xsl:variable 
      name="collation" 
      select="
      concat(
      'http://saxon.sf.net/collation?alphanumeric=yes;normalization=yes;ignore-case=yes;lang=', 
      $webhelp_language)"/>
    
    <xsl:variable name="indexTermsAlphabetLabel">
      <xsl:for-each select="$i18n_context[1]">
        <xsl:call-template name="getWebhelpString">
          <xsl:with-param name="stringName" select="'index.terms.alphabet'"/>
        </xsl:call-template>
      </xsl:for-each>
    </xsl:variable>
    
    <xsl:variable name="indexTermsLetterLabel">
      <xsl:for-each select="$i18n_context[1]">
        <xsl:call-template name="getWebhelpString">
          <xsl:with-param name="stringName" select="'index.terms.for.letter'"/>
        </xsl:call-template>
      </xsl:for-each>
    </xsl:variable>
    
    
    <!-- 
      Generates the list of the letters from terms list 
      EXM-37491
    -->
    <ul class="wh-letters" tabindex="0" role="menu" aria-label="{$indexTermsAlphabetLabel}">      
      <xsl:for-each-group select="index:term" group-by="
        upper-case(
        translate(
        substring(
        normalize-unicode(@sort-as, 'NFD'), 1, 1), $katakana_chars, $hiragana_chars))" 
        collation="{$collation}">
        <xsl:sort select="current-grouping-key()" collation="{$collation}"/>
      <!-- Output the first letter -->
        <li>
          <a href="#whletter_{escape-html-uri(lower-case(current-grouping-key()))}" 
            aria-label="{concat($indexTermsLetterLabel, ' ', current-grouping-key())}">
            <xsl:value-of select="current-grouping-key()"/>
          </a>
        </li>
      </xsl:for-each-group>
    </ul>
    
    <ul id="indexList" role="tree">
      <xsl:for-each-group select="index:term" group-by="
        upper-case(
        translate(
        substring(
        normalize-unicode(@sort-as, 'NFD'), 1, 1), $katakana_chars, $hiragana_chars))" 
        collation="{$collation}">
        <xsl:sort select="current-grouping-key()" collation="{$collation}"/>
        <!-- Output the first letter -->
        <li class="wh_term_group" role="treeitem" id="whletter_{escape-html-uri(lower-case(current-grouping-key()))}"
          aria-label="{concat($indexTermsLetterLabel, ' ', current-grouping-key())}"
          tabindex="0">
        <span class="wh_first_letter"><xsl:value-of 
          select="current-grouping-key()"/></span>
        <ul>
          <!-- Iterates over the current group and output its items -->
          <xsl:apply-templates select="current-group()" mode="#current">
            <xsl:sort select="@sort-as" collation="{$collation}"/>
            <xsl:with-param name="collation" select="$collation"/>
          </xsl:apply-templates>
        </ul>
      </li>
    </xsl:for-each-group>
    </ul>
  </xsl:template>
  
  <xsl:template match="html:html" mode="copy_template">
    <xsl:copy copy-namespaces="no">
      <xsl:apply-templates select="@*" mode="#current"/>
      <xsl:attribute name="lang" select="oxygen:getParameter('webhelp.language')"/>
      <xsl:attribute name="dir" select="oxygen:getParameter('webhelp.page.direction')"/>
      
      <!-- Copy elements -->
      <xsl:apply-templates select="node()" mode="#current"/>
    </xsl:copy>
  </xsl:template>
  
  <!--
    Template used to generate indexterms
  -->
  <xsl:template match="whc:webhelp_index_terms" mode="copy_template">
    <div>
      <xsl:call-template name="generateComponentClassAttribute">
        <xsl:with-param name="compClass">wh_index_terms</xsl:with-param>
      </xsl:call-template>
      <xsl:copy-of select="@* except @class"/>
      <xsl:if test="count($index/*) > 0">
        <xsl:variable name="compContent">
          <div id="iList">
            <xsl:variable name="indexterms">
              <xsl:apply-templates select="$index" mode="create-index"/>
            </xsl:variable>
            <!--<xsl:copy-of select="$indexterms"/>-->
            <xsl:apply-templates select="$indexterms" mode="fixup_XHTML_NS"/>
          </div>
        </xsl:variable>
        
        <xsl:call-template name="outputComponentContent">
          <xsl:with-param name="compContent" select="$compContent"/>
          <xsl:with-param name="compName" select="local-name()"/>
        </xsl:call-template>
      </xsl:if>
    </div>
  </xsl:template>
  
  <!-- 
    Generates a list item for each index term.
  -->  
  <xsl:template match="index:term" mode="create-index">
    <!-- EXM-36947 - Use a collation to support multi language sort -->
    <xsl:param name="collation"/>
    <xsl:param name="parentIndexTerm" select="''"/>
    <li class="wh_term">
      <span><xsl:value-of select="@name"/></span>
      
      <!-- Handle see and see-also -->
      <xsl:if test="@see">
        <xsl:variable name="see">
          <xsl:choose>
            <xsl:when test="exists($i18n_context)">                            
              <xsl:for-each select="$i18n_context[1]">
                <xsl:call-template name="getWebhelpString">
                  <xsl:with-param name="stringName" select="'label.see'"/>
                </xsl:call-template>
              </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>See</xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <span class="wh_term_see">
          <xsl:text> </xsl:text>
          <xsl:value-of select="$see"/>
          <xsl:text> </xsl:text>
          <xsl:value-of select="@see"/>
        </span>
      </xsl:if>
      <xsl:if test="@see-also">
        <xsl:variable name="seeAlso">
          <xsl:choose>
            <xsl:when test="exists($i18n_context)">                            
              <xsl:for-each select="$i18n_context[1]">
                <xsl:call-template name="getWebhelpString">
                  <xsl:with-param name="stringName" select="'label.see_also'"/>
                </xsl:call-template>
              </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>See also</xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <span class="wh_term_see-also">
          <xsl:text> </xsl:text>
          <xsl:value-of select="$seeAlso"/>
          <xsl:text> </xsl:text>
          <xsl:value-of select="@see-also"/>
        </span>
      </xsl:if>
      
      <xsl:variable name="indexTermLabel">
        <xsl:for-each select="$i18n_context[1]">
          <xsl:call-template name="getWebhelpString">
            <xsl:with-param name="stringName" select="'index.term'"/>
          </xsl:call-template>
        </xsl:for-each>
      </xsl:variable>
      
      <!-- Generate links for each target -->
      <xsl:variable name="cTerm" select="@name"/>
      <xsl:for-each select="index:target">
        <a class="wh_term_target" href="{.}" 
          aria-label="{concat($indexTermLabel, $parentIndexTerm, ' ', $cTerm)}">[<xsl:value-of select="position()"/>]</a>
      </xsl:for-each>
      
      <!-- Handle nested index terms -->
      <xsl:if test="count(index:term) > 0">      
        <ul>
          <xsl:apply-templates mode="#current" select="index:term">
            <xsl:sort select="@sort-as" collation="{$collation}"/>
            <xsl:with-param name="collation" select="$collation"/>
            <xsl:with-param 
              name="parentIndexTerm" 
              select="concat($parentIndexTerm, ' ', @name)"></xsl:with-param>
          </xsl:apply-templates>
        </ul>
      </xsl:if>
    </li>
  </xsl:template>
  
  <!--
    Generate page title. Index Terms - map title
  -->
  <xsl:template name="generatePageTitle">
    <xsl:param name="mainBookTitle"/>
    <xsl:param name="mapTitle"/>
    <title>
      <xsl:choose>
        <xsl:when test="exists($i18n_context)">
          <xsl:for-each select="$i18n_context[1]">
            <xsl:call-template name="getWebhelpString">
              <xsl:with-param name="stringName" select="'index.terms.page.title'"/>
            </xsl:call-template>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>Index Terms</xsl:otherwise>
      </xsl:choose>
      
      <xsl:choose>
        <xsl:when test="exists($mainBookTitle)">
          <xsl:value-of select="concat(' - ', $mainBookTitle)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="concat(' - ', $mapTitle)"/>
        </xsl:otherwise>
      </xsl:choose>
    </title>
  </xsl:template>
</xsl:stylesheet>