/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl.highlighters;

import java.util.ArrayList;
import java.util.List;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.HighlighterConfigurationException;
import net.sf.xslthl.Params;

public class WordHighlighter
extends Highlighter {
    protected List<String> words;
    protected boolean caseInsensitive;

    @Override
    public void init(Params params) throws HighlighterConfigurationException {
        super.init(params);
        this.words = new ArrayList<String>();
        params.getMutliParams("word", this.words);
        this.caseInsensitive = params.isSet("ignoreCase");
    }

    @Override
    public boolean startsWith(CharIter in) {
        for (String string : this.words) {
            if (!in.startsWith(string, this.caseInsensitive)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDefaultStyle() {
        return null;
    }

    @Override
    public boolean highlight(CharIter in, List<Block> out) {
        for (String string : this.words) {
            if (!in.startsWith(string, this.caseInsensitive)) continue;
            in.moveNext(string.length());
            if (!in.finished() && !Character.isWhitespace(in.current().charValue())) continue;
            out.add(in.markedToStyledBlock(this.styleName));
            return true;
        }
        return false;
    }
}

