/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl.highlighters;

import java.util.ArrayList;
import java.util.List;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.HighlighterConfigurationException;
import net.sf.xslthl.Params;

public class NumberHighlighter
extends Highlighter {
    protected String decimalPoint;
    protected String thousandSep;
    protected String exponent;
    protected List<String> suffix;
    protected String prefix;
    protected boolean ignoreCase;
    protected boolean pointStarts;
    protected boolean letterNoFollow;

    @Override
    public void init(Params params) throws HighlighterConfigurationException {
        super.init(params);
        this.decimalPoint = params.getParam("point");
        this.thousandSep = params.getParam("thousands");
        this.exponent = params.getParam("exponent");
        this.pointStarts = this.decimalPoint != null && params.isSet("pointStarts");
        this.ignoreCase = params.isSet("ignoreCase");
        this.suffix = new ArrayList<String>();
        params.getMutliParams("suffix", this.suffix);
        this.prefix = params.getParam("prefix");
        this.letterNoFollow = params.isSet("cleanEnd");
    }

    protected boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    @Override
    public String getDefaultStyle() {
        return "number";
    }

    @Override
    public boolean startsWith(CharIter in) {
        Character next;
        if (in.getPosition() > 0 && this.prefix == null && (Character.isLetter(in.prev().charValue()) || this.isDigit(in.prev().charValue()))) {
            return false;
        }
        if (this.prefix != null) {
            return in.startsWith(this.prefix, this.ignoreCase) && this.isDigit(in.next(this.prefix.length()).charValue());
        }
        if (this.pointStarts && in.startsWith(this.decimalPoint, this.ignoreCase) && (next = in.next(this.decimalPoint.length())) != null && this.isDigit(next.charValue())) {
            return true;
        }
        return this.isDigit(in.current().charValue());
    }

    @Override
    public boolean highlight(CharIter in, List<Block> out) {
        boolean hadPoint = false;
        boolean hadExponent = false;
        if (this.prefix != null && in.startsWith(this.prefix, this.ignoreCase)) {
            in.moveNext(this.prefix.length());
        }
        if (this.pointStarts && in.startsWith(this.decimalPoint, this.ignoreCase)) {
            in.moveNext(this.decimalPoint.length());
            hadPoint = true;
        }
        while (!in.finished()) {
            if (!hadPoint) {
                if (this.decimalPoint != null && in.startsWith(this.decimalPoint, this.ignoreCase)) {
                    hadPoint = true;
                    in.moveNext(this.decimalPoint.length());
                    continue;
                }
                if (this.thousandSep != null && in.startsWith(this.thousandSep, this.ignoreCase)) {
                    in.moveNext(this.thousandSep.length());
                    continue;
                }
            }
            if (!hadExponent && this.exponent != null && in.startsWith(this.exponent, this.ignoreCase)) {
                hadPoint = true;
                hadExponent = true;
                in.moveNext(this.exponent.length());
                if (!in.current().equals(Character.valueOf('-')) && !in.current().equals(Character.valueOf('+'))) continue;
                in.moveNext();
                continue;
            }
            if (!this.isDigit(in.current().charValue())) break;
            in.moveNext();
        }
        for (String suf : this.suffix) {
            if (!in.startsWith(suf, this.ignoreCase)) continue;
            in.moveNext(suf.length());
            break;
        }
        if (this.letterNoFollow && !in.finished() && Character.isLetter(in.current().charValue())) {
            return false;
        }
        out.add(in.markedToStyledBlock(this.styleName));
        return true;
    }
}

