/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl.highlighters;

import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.HighlighterConfigurationException;
import net.sf.xslthl.Params;

public class KeywordsHighlighter
extends Highlighter {
    protected Collection<String> keywords;
    protected boolean ignoreCase = false;
    protected String startChars;
    protected String partChars;
    protected boolean exclusiveChars;

    @Override
    public void init(Params params) throws HighlighterConfigurationException {
        super.init(params);
        this.ignoreCase = params.isSet("ignoreCase");
        this.exclusiveChars = params.isSet("exclusiveChars");
        this.keywords = this.ignoreCase ? new TreeSet<String>(new Highlighter.IgnoreCaseComparator()) : new TreeSet<String>();
        params.getMutliParams("keyword", this.keywords);
        this.startChars = params.getParam("beginChars");
        this.partChars = params.getParam("partChars");
    }

    protected void appendUnique(StringBuilder buf, char ch) {
        int i = 0;
        while (i < buf.length()) {
            if (buf.charAt(i) == ch) {
                return;
            }
            ++i;
        }
        buf.append(ch);
    }

    @Override
    public boolean startsWith(CharIter in) {
        return this.isIdentifierStart(in.current().charValue()) && (in.prev() == null || !this.isIdentifierPart(in.prev().charValue()));
    }

    @Override
    public boolean highlight(CharIter in, List<Block> out) {
        while (!in.finished() && this.isIdentifierPart(in.current().charValue())) {
            in.moveNext();
        }
        if (this.keywords.contains(in.getMarked())) {
            out.add(in.markedToStyledBlock(this.styleName));
            return true;
        }
        return false;
    }

    @Override
    public String getDefaultStyle() {
        return "keyword";
    }

    protected boolean isIdentifierStart(char ch) {
        if (this.startChars != null) {
            if (this.startChars.indexOf(ch) != -1) {
                return true;
            }
            if (this.exclusiveChars) {
                return false;
            }
        }
        return Character.isJavaIdentifierStart(ch);
    }

    protected boolean isIdentifierPart(char ch) {
        if (this.partChars != null) {
            if (this.partChars.indexOf(ch) != -1) {
                return true;
            }
            if (this.exclusiveChars) {
                return false;
            }
        }
        return Character.isJavaIdentifierPart(ch);
    }
}

