/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl.highlighters;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.HighlighterConfigurationException;
import net.sf.xslthl.Params;

public class HeredocHighlighter
extends Highlighter {
    protected String start;
    protected Set<String> quoteChar;
    protected boolean noWhiteSpace;
    protected boolean looseTerminator;
    protected boolean indentFlag;
    protected Set<String> flags;

    @Override
    public void init(Params params) throws HighlighterConfigurationException {
        super.init(params);
        this.start = params.getParam("start");
        if (this.start == null || this.start.length() == 0) {
            throw new HighlighterConfigurationException("Required parameter 'start' is not set.");
        }
        this.quoteChar = new HashSet<String>();
        params.getMutliParams("quote", this.quoteChar);
        this.noWhiteSpace = params.isSet("noWhiteSpace");
        this.looseTerminator = params.isSet("looseTerminator");
        this.flags = new HashSet<String>();
        params.getMutliParams("flag", this.flags);
    }

    @Override
    public boolean startsWith(CharIter in) {
        if (in.startsWith(this.start)) {
            if (this.noWhiteSpace) {
                return !Character.isWhitespace(in.next(this.start.length() + 1).charValue());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean highlight(CharIter in, List<Block> out) {
        int i;
        in.moveNext(this.start.length());
        while (this.flags.contains(in.current().toString())) {
            in.moveNext();
        }
        if (!this.noWhiteSpace) {
            while (!in.finished() && Character.isWhitespace(in.current().charValue())) {
                in.moveNext();
            }
        }
        StringBuilder heredocId = new StringBuilder();
        Character quoted = Character.valueOf('\u0000');
        if (this.quoteChar.contains(in.current().toString())) {
            quoted = in.current();
            in.moveNext();
        }
        while (!(in.finished() || !Character.isLetterOrDigit(in.current().charValue()) && in.current().charValue() != '_' || quoted.equals(in.current()))) {
            heredocId.append(in.current());
            in.moveNext();
        }
        if (quoted.equals(in.current())) {
            in.moveNext();
        }
        if (heredocId.length() == 0) {
            return false;
        }
        do {
            if ((i = in.indexOf(heredocId.toString())) < 0) {
                in.moveToEnd();
                continue;
            }
            in.moveNext(i + heredocId.length());
        } while (!this.looseTerminator && !HeredocHighlighter.isNewLine(in.prev(heredocId.length() + 1)) && i != -1);
        out.add(in.markedToStyledBlock(this.styleName));
        return true;
    }

    @Override
    public String getDefaultStyle() {
        return "string";
    }
}

