/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl;

import java.util.Collection;
import net.sf.xslthl.HighlighterConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Params {
    protected Element paramElem;

    public Params(Element paramElem) {
        this.paramElem = paramElem;
    }

    protected String getTextContent(Node elm) {
        if (elm == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        NodeList list = elm.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node n = list.item(i);
            if (sb.length() > 0) {
                sb.append(' ');
            }
            if (n.getNodeType() == 4) {
                sb.append(n.getTextContent());
            } else {
                sb.append(n.getTextContent().trim());
            }
            ++i;
        }
        return sb.toString();
    }

    public String getParam() {
        return this.getTextContent(this.paramElem);
    }

    public String getParam(String name) {
        return this.getParam(name, null);
    }

    public String getParam(String name, String defaultValue) {
        NodeList nodes = this.paramElem.getElementsByTagName(name);
        if (nodes.getLength() == 0) {
            return defaultValue;
        }
        return this.getTextContent(nodes.item(0));
    }

    public Params getParams(String name) {
        Element elm = (Element)this.paramElem.getElementsByTagName(name).item(0);
        if (elm == null) {
            return null;
        }
        return new Params(elm);
    }

    public boolean isSet(String name) {
        return this.paramElem.getElementsByTagName(name).getLength() > 0;
    }

    public void getMutliParams(String name, Collection<String> list) {
        NodeList nodes = this.paramElem.getElementsByTagName(name);
        int i = 0;
        while (i < nodes.getLength()) {
            Element elem = (Element)nodes.item(i);
            list.add(this.getTextContent(elem));
            ++i;
        }
    }

    public <T> void getMultiParams(String name, Collection<T> list, ParamsLoader<? extends T> loader) throws HighlighterConfigurationException {
        NodeList nodes = this.paramElem.getElementsByTagName(name);
        int i = 0;
        while (i < nodes.getLength()) {
            Element elem = (Element)nodes.item(i);
            list.add(loader.load(new Params(elem)));
            ++i;
        }
    }

    public static interface ParamsLoader<T> {
        public T load(Params var1) throws HighlighterConfigurationException;
    }
}

