/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.StyledBlock;
import net.sf.xslthl.WholeHighlighter;

public class MainHighlighter {
    protected String id;
    protected String filename;
    protected List<Highlighter> highlighters = new ArrayList<Highlighter>();
    protected List<WholeHighlighter> wholehighlighters = new ArrayList<WholeHighlighter>();

    public MainHighlighter(String highlighterId, String configFilename) {
        this.id = highlighterId;
        this.filename = configFilename;
    }

    public String getId() {
        return this.id;
    }

    public String getFilename() {
        return this.filename;
    }

    public void add(Highlighter h) {
        if (h instanceof WholeHighlighter) {
            this.wholehighlighters.add((WholeHighlighter)h);
        } else {
            this.highlighters.add(h);
        }
    }

    @Deprecated
    public void addWhole(WholeHighlighter h) {
        this.add(h);
    }

    public List<Block> highlight(String source) {
        CharIter in = new CharIter(source);
        AbstractList out = new ArrayList<Block>();
        if (this.highlighters.size() > 0) {
            while (!in.finished()) {
                boolean found = false;
                for (Highlighter h : this.highlighters) {
                    if (!h.startsWith(in)) continue;
                    int pos = in.getPosition();
                    int oldMark = -2;
                    Block preBlock = null;
                    if (in.isMarked()) {
                        oldMark = in.getMark();
                        preBlock = in.markedToBlock();
                        out.add((Block)preBlock);
                    }
                    if (found = h.highlight(in, out)) break;
                    in.moveNext(pos - in.getPosition());
                    if (preBlock != null) {
                        out.remove(preBlock);
                    }
                    if (oldMark == -2) continue;
                    in.setMark(oldMark);
                }
                if (found) continue;
                in.moveNext();
            }
        } else {
            in.moveToEnd();
        }
        if (in.isMarked()) {
            out.add(in.markedToBlock());
        }
        if (this.wholehighlighters.size() > 0) {
            for (WholeHighlighter h : this.wholehighlighters) {
                ArrayList<Block> oldout = out;
                out = new LinkedList();
                for (Block b : oldout) {
                    if (b.isStyled() && (h.appliesOnAllStyles() || h.appliesOnStyle(((StyledBlock)b).getStyle())) || !b.isStyled() && h.appliesOnEmptyStyle()) {
                        h.highlight(new CharIter(b.getText()), out);
                        continue;
                    }
                    out.add(b);
                }
            }
        }
        for (Highlighter h : this.highlighters) {
            h.reset();
        }
        for (WholeHighlighter h : this.wholehighlighters) {
            h.reset();
        }
        return out;
    }
}

