/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.saxon.event.Builder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.SchemaType;
import net.sf.xslthl.Block;
import net.sf.xslthl.Config;
import net.sf.xslthl.MainHighlighter;
import net.sf.xslthl.StyledBlock;

public class ConnectorSaxonEE {
    private static Logger logger = Logger.getLogger("net.sf.xslthl.saxon9eeconnector");

    private static void blockToSaxon9Node(Block b, Builder builder, Config config) throws Exception {
        if (b.isStyled()) {
            Object fpQname = null;
            try {
                Class<?> fpQnameClazz = Class.forName("net.sf.saxon.om.FingerprintedQName");
                Constructor<?> constructor = fpQnameClazz.getConstructor(String.class, String.class, String.class);
                fpQname = constructor.newInstance(config.prefix, config.uri, ((StyledBlock)b).getStyle());
            }
            catch (Exception ex) {
                Class<?> fpQnameClazz = Class.forName("net.sf.saxon.om.FingerprintedQName");
                Class<?> nsURIClass = Class.forName("net.sf.saxon.om.NamespaceUri");
                Method of = nsURIClass.getMethod("of", String.class);
                Constructor<?> constructor = fpQnameClazz.getConstructor(String.class, nsURIClass, String.class);
                fpQname = constructor.newInstance(config.prefix, of.invoke(null, config.uri), ((StyledBlock)b).getStyle());
            }
            ConnectorSaxonEE.startElement(builder, fpQname);
            ConnectorSaxonEE.outputCharacters(builder, b.getText());
            builder.endElement();
        } else {
            ConnectorSaxonEE.outputCharacters(builder, b.getText());
        }
    }

    private static void startElement(Builder builder, Object fpQname) throws Exception {
        try {
            Method startElement = builder.getClass().getMethod("startElement", Class.forName("net.sf.saxon.om.NodeName"), SchemaType.class, Integer.TYPE, Integer.TYPE);
            startElement.invoke((Object)builder, fpQname, AnyType.getInstance(), 0, 0);
        }
        catch (Exception ex) {
            try {
                Method startElement = builder.getClass().getMethod("startElement", Class.forName("net.sf.saxon.om.NodeName"), SchemaType.class, Class.forName("net.sf.saxon.expr.parser.Location"), Integer.TYPE);
                startElement.invoke((Object)builder, fpQname, AnyType.getInstance(), ConnectorSaxonEE.createFakeLocation(false), 0);
            }
            catch (Exception ex2) {
                Method startElement = builder.getClass().getMethod("startElement", Class.forName("net.sf.saxon.om.NodeName"), SchemaType.class, Class.forName("net.sf.saxon.om.AttributeMap"), Class.forName("net.sf.saxon.om.NamespaceMap"), Class.forName("net.sf.saxon.s9api.Location"), Integer.TYPE);
                Class<?> emptyAttrClazz = Class.forName("net.sf.saxon.om.EmptyAttributeMap");
                Method attrsInstance = emptyAttrClazz.getMethod("getInstance", new Class[0]);
                Class<?> emptyNMClazz = Class.forName("net.sf.saxon.om.NamespaceMap");
                Method mapInstance = emptyNMClazz.getMethod("emptyMap", new Class[0]);
                startElement.invoke((Object)builder, fpQname, AnyType.getInstance(), attrsInstance.invoke(null, new Object[0]), mapInstance.invoke(null, new Object[0]), ConnectorSaxonEE.createFakeLocation(true), 0);
            }
        }
    }

    private static void outputCharacters(Builder builder, String text) throws Exception {
        Method characters = null;
        try {
            characters = builder.getClass().getMethod("characters", String.class, Integer.TYPE, Integer.TYPE);
            characters.invoke((Object)builder, text, 0, 0);
        }
        catch (Exception ex) {
            try {
                characters = builder.getClass().getMethod("characters", CharSequence.class, Class.forName("net.sf.saxon.expr.parser.Location"), Integer.TYPE);
                characters.invoke((Object)builder, text, ConnectorSaxonEE.createFakeLocation(false), 0);
            }
            catch (Exception ex2) {
                try {
                    characters = builder.getClass().getMethod("characters", CharSequence.class, Class.forName("net.sf.saxon.s9api.Location"), Integer.TYPE);
                    characters.invoke((Object)builder, text, ConnectorSaxonEE.createFakeLocation(true), 0);
                }
                catch (Exception ex3) {
                    Class<?> stClass = Class.forName("net.sf.saxon.str.StringTool");
                    Method fromCS = stClass.getMethod("fromCharSequence", CharSequence.class);
                    Object unicodeObj = fromCS.invoke(null, text);
                    Class<?> unicodeStrClass = Class.forName("net.sf.saxon.str.UnicodeString");
                    characters = builder.getClass().getMethod("characters", unicodeStrClass, Class.forName("net.sf.saxon.s9api.Location"), Integer.TYPE);
                    characters.invoke((Object)builder, unicodeObj, ConnectorSaxonEE.createFakeLocation(true), 0);
                }
            }
        }
    }

    private static Object createFakeLocation(boolean saxon10OrNewer) throws IllegalArgumentException, ClassNotFoundException {
        return Proxy.newProxyInstance(ConnectorSaxonEE.class.getClassLoader(), new Class[]{Class.forName(saxon10OrNewer ? "net.sf.saxon.s9api.Location" : "net.sf.saxon.expr.parser.Location")}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("saveLocation".equals(method.getName())) {
                    return proxy;
                }
                if ("getSystemId".equals(method.getName()) || "getPublicId".equals(method.getName())) {
                    return null;
                }
                if ("getLineNumber".equals(method.getName()) || "getColumnNumber".equals(method.getName())) {
                    return 0;
                }
                return null;
            }
        });
    }

    public static SequenceIterator highlight(XPathContext context, String hlCode, SequenceIterator nodes) throws Exception {
        return ConnectorSaxonEE.highlight(context, hlCode, nodes, null);
    }

    public static SequenceIterator highlight(XPathContext context, String hlCode, SequenceIterator seq, String configFilename) throws Exception {
        try {
            Config c = Config.getInstance(configFilename);
            MainHighlighter hl = c.getMainHighlighter(hlCode);
            Object childType = Class.forName("net.sf.saxon.om.AxisInfo").getField("CHILD").get(null);
            Method iterateAxis = null;
            try {
                iterateAxis = Class.forName("net.sf.saxon.om.NodeInfo").getMethod("iterateAxis", Byte.TYPE);
            }
            catch (NoSuchMethodException t) {
                iterateAxis = Class.forName("net.sf.saxon.om.NodeInfo").getMethod("iterateAxis", Integer.TYPE);
            }
            Class<?> axisIterClazz = Class.forName("net.sf.saxon.tree.iter.AxisIterator");
            Method next = axisIterClazz.getMethod("next", new Class[0]);
            ArrayList<Object> resultNodes = new ArrayList<Object>();
            Item itm = null;
            while ((itm = seq.next()) != null) {
                if (itm instanceof NodeInfo) {
                    NodeInfo ni = (NodeInfo)itm;
                    SequenceIterator ae = (SequenceIterator)iterateAxis.invoke((Object)ni, childType);
                    Item itm2 = null;
                    while ((itm2 = ae.next()) != null) {
                        if (itm2 instanceof NodeInfo) {
                            NodeInfo n2i = (NodeInfo)itm2;
                            if (n2i.getNodeKind() == 3) {
                                if (hl != null) {
                                    try {
                                        Builder builder = context.getController().makeBuilder();
                                        builder.open();
                                        builder.startDocument(0);
                                        List<Block> l = hl.highlight(n2i.getStringValue());
                                        for (Block b : l) {
                                            ConnectorSaxonEE.blockToSaxon9Node(b, builder, c);
                                        }
                                        builder.endDocument();
                                        builder.close();
                                        NodeInfo doc = builder.getCurrentRoot();
                                        Object elms = iterateAxis.invoke((Object)doc, childType);
                                        Item crt = null;
                                        while ((crt = (Item)next.invoke(elms, new Object[0])) != null) {
                                            resultNodes.add(crt);
                                        }
                                    }
                                    catch (Exception ex) {
                                        logger.log(Level.SEVERE, String.format("Highligher threw unhandled error at position %s: %s", n2i.getStringValue(), ex.getMessage()), ex);
                                        resultNodes.add(n2i);
                                    }
                                    continue;
                                }
                                resultNodes.add(n2i);
                                continue;
                            }
                            resultNodes.add(n2i);
                            continue;
                        }
                        resultNodes.add(itm2);
                    }
                    continue;
                }
                resultNodes.add(itm);
            }
            try {
                Class<?> lstIterClassName = Class.forName("net.sf.saxon.tree.iter.ListIterator");
                Constructor<?> constructor = lstIterClassName.getConstructor(List.class);
                return (SequenceIterator)constructor.newInstance(resultNodes);
            }
            catch (Exception ex) {
                Class<?> ofClass = Class.forName("net.sf.saxon.tree.iter.ListIterator$Of");
                Constructor<?> ofConstructor = ofClass.getConstructor(List.class);
                return (SequenceIterator)ofConstructor.newInstance(resultNodes);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }
}

