/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.saxon.event.Builder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ListIterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.xslthl.Block;
import net.sf.xslthl.Config;
import net.sf.xslthl.MainHighlighter;
import net.sf.xslthl.StyledBlock;

public class ConnectorSaxonB {
    private static Logger logger = Logger.getLogger("net.sf.xslthl.saxon9Bconnector");

    private static void blockToSaxon9Node(Block b, Builder builder, NamePool pool, Config config) throws Exception {
        if (b.isStyled()) {
            int elemId = pool.allocate(config.prefix, config.uri, ((StyledBlock)b).getStyle());
            builder.startElement(elemId, -1, 0, 0);
            builder.characters((CharSequence)b.getText(), 0, b.getText().length());
            builder.endElement();
        } else {
            builder.characters((CharSequence)b.getText(), 0, b.getText().length());
        }
    }

    public static SequenceIterator highlight(XPathContext context, String hlCode, SequenceIterator nodes) throws Exception {
        return ConnectorSaxonB.highlight(context, hlCode, nodes, null);
    }

    public static SequenceIterator highlight(XPathContext context, String hlCode, SequenceIterator seq, String configFilename) throws Exception {
        try {
            Config c = Config.getInstance(configFilename);
            MainHighlighter hl = c.getMainHighlighter(hlCode);
            NamePool pool = context.getController().getNamePool();
            ArrayList<Object> resultNodes = new ArrayList<Object>();
            while (seq.next() != null) {
                Item itm = seq.current();
                if (itm instanceof NodeInfo) {
                    NodeInfo ni = (NodeInfo)itm;
                    AxisIterator ae = ni.iterateAxis((byte)3, (NodeTest)AnyNodeTest.getInstance());
                    while (ae.next() != null) {
                        Item itm2 = ae.current();
                        if (itm2 instanceof NodeInfo) {
                            NodeInfo n2i = (NodeInfo)itm2;
                            if (n2i.getNodeKind() == 3) {
                                if (hl != null) {
                                    try {
                                        Builder builder = context.getController().makeBuilder();
                                        builder.open();
                                        builder.startDocument(0);
                                        List<Block> l = hl.highlight(n2i.getStringValue());
                                        for (Block b : l) {
                                            ConnectorSaxonB.blockToSaxon9Node(b, builder, pool, c);
                                        }
                                        builder.endDocument();
                                        builder.close();
                                        NodeInfo doc = builder.getCurrentRoot();
                                        AxisIterator elms = doc.iterateAxis((byte)3, (NodeTest)AnyNodeTest.getInstance());
                                        while (elms.next() != null) {
                                            resultNodes.add(elms.current());
                                        }
                                    }
                                    catch (Exception ex) {
                                        logger.log(Level.SEVERE, String.format("Highligher threw unhandled error at position %s: %s", n2i.getStringValue(), ex.getMessage()), ex);
                                        resultNodes.add(n2i);
                                    }
                                    continue;
                                }
                                resultNodes.add(n2i);
                                continue;
                            }
                            resultNodes.add(n2i);
                            continue;
                        }
                        resultNodes.add(itm2);
                    }
                    continue;
                }
                resultNodes.add(itm);
            }
            return new ListIterator(resultNodes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

