/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

import ro.sync.basic.util.NumberFormatException;

public final class NumberParserUtil {
    private NumberParserUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static byte parseByte(String s) throws NumberFormatException {
        return NumberParserUtil.parseByte(s, 10);
    }

    public static byte parseByte(String s, int radix) throws NumberFormatException {
        try {
            return Byte.parseByte(s, radix);
        }
        catch (java.lang.NumberFormatException e) {
            throw new NumberFormatException(e.getMessage(), e);
        }
    }

    public static Byte valueOfByte(String s) throws NumberFormatException {
        return NumberParserUtil.valueOfByte(s, 10);
    }

    public static Byte valueOfByte(String s, int radix) throws NumberFormatException {
        try {
            return Byte.valueOf(s, radix);
        }
        catch (java.lang.NumberFormatException e) {
            throw new NumberFormatException(e.getMessage(), e);
        }
    }

    public static short parseShort(String s) throws NumberFormatException {
        return NumberParserUtil.parseShort(s, 10);
    }

    public static short parseShort(String s, int radix) throws NumberFormatException {
        try {
            return Short.parseShort(s, radix);
        }
        catch (java.lang.NumberFormatException e) {
            throw new NumberFormatException(e.getMessage(), e);
        }
    }

    public static Short valueOfShort(String s) throws NumberFormatException {
        return NumberParserUtil.valueOfShort(s, 10);
    }

    public static Short valueOfShort(String s, int radix) throws NumberFormatException {
        try {
            return Short.valueOf(s, radix);
        }
        catch (java.lang.NumberFormatException e) {
            throw new NumberFormatException(e.getMessage(), e);
        }
    }

    public static int parseInt(String s, int radix) throws NumberFormatException {
        try {
            return Integer.parseInt(s, radix);
        }
        catch (java.lang.NumberFormatException e) {
            throw new NumberFormatException(e.getMessage(), e);
        }
    }

    public static int parseInt(String s) throws NumberFormatException {
        return NumberParserUtil.parseInt(s, 10);
    }

    public static Integer valueOfInteger(String s) throws NumberFormatException {
        return NumberParserUtil.valueOfInteger(s, 10);
    }

    public static Integer valueOfInteger(String s, int radix) throws NumberFormatException {
        try {
            return Integer.valueOf(s, radix);
        }
        catch (java.lang.NumberFormatException e) {
            throw new NumberFormatException(e.getMessage(), e);
        }
    }

    public static Integer valueOfInteger(int i) {
        return i;
    }

    public static long parseLong(String s) throws NumberFormatException {
        return NumberParserUtil.parseLong(s, 10);
    }

    public static long parseLong(String s, int radix) throws NumberFormatException {
        try {
            return Long.parseLong(s, radix);
        }
        catch (java.lang.NumberFormatException e) {
            throw new NumberFormatException(e.getMessage(), e);
        }
    }

    public static Long valueOfLong(String s) throws NumberFormatException {
        return NumberParserUtil.valueOfLong(s, 10);
    }

    public static Long valueOfLong(String s, int radix) throws NumberFormatException {
        try {
            return Long.valueOf(s, radix);
        }
        catch (java.lang.NumberFormatException e) {
            throw new NumberFormatException(e.getMessage(), e);
        }
    }

    public static Long valueOfLong(long l) {
        return l;
    }

    public static float parseFloat(String s) throws NumberFormatException {
        try {
            return Float.parseFloat(s);
        }
        catch (java.lang.NumberFormatException e) {
            throw new NumberFormatException(e.getMessage(), e);
        }
    }

    public static Float valueOfFloat(String s) throws NumberFormatException {
        try {
            return Float.valueOf(s);
        }
        catch (java.lang.NumberFormatException e) {
            throw new NumberFormatException(e.getMessage(), e);
        }
    }

    public static Float valueOfFloat(float f) {
        return Float.valueOf(f);
    }

    public static double parseDouble(String s) throws NumberFormatException {
        try {
            return Double.parseDouble(s);
        }
        catch (java.lang.NumberFormatException e) {
            throw new NumberFormatException(e.getMessage(), e);
        }
    }

    public static Double valueOfDouble(String s) throws NumberFormatException {
        try {
            return Double.valueOf(s);
        }
        catch (java.lang.NumberFormatException e) {
            throw new NumberFormatException(e.getMessage(), e);
        }
    }
}

