/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.prettyprint;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.SerializerFactory;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import ro.sync.basic.prettyprint.SimplePrettyPrinterException;

public class SimplePrettyPrinter {
    public static String prettyPrint(String fileContent) throws SimplePrettyPrinterException {
        return SimplePrettyPrinter.prettyPrint(fileContent, false);
    }

    public static String prettyPrint(String fileContent, boolean omitXMLDecl) throws SimplePrettyPrinterException {
        String formatted = null;
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(fileContent)));
            document.normalize();
            formatted = SimplePrettyPrinter.prettyPrintNode(document, omitXMLDecl).concat("\n");
        }
        catch (IOException e) {
            throw new SimplePrettyPrinterException("Cannot format:\n" + fileContent, e);
        }
        catch (SAXException e) {
            throw new SimplePrettyPrinterException("Cannot format\n" + fileContent, e);
        }
        catch (ParserConfigurationException e) {
            throw new SimplePrettyPrinterException("Cannot format\n" + fileContent, e);
        }
        return formatted;
    }

    public static String prettyPrintNode(Node node, boolean omitXMLDecl) throws IOException, SimplePrettyPrinterException {
        SerializerFactory serializerFactory = SerializerFactory.getSerializerFactory((String)"xml");
        OutputFormat format = new OutputFormat();
        format.setLineWidth(1000);
        format.setLineSeparator("\n");
        format.setIndenting(true);
        format.setIndent(2);
        format.setMethod("xml");
        format.setOmitXMLDeclaration(omitXMLDecl);
        XMLSerializer serializer = new XMLSerializer(format);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        serializer.setOutputByteStream((OutputStream)outputStream);
        String charsetName = "UTF-8";
        if (node.getNodeType() == 1) {
            serializer.serialize((Element)node);
        } else if (node.getNodeType() == 9) {
            serializer.serialize((Document)node);
        } else if (node.getNodeType() == 2) {
            outputStream.write(("@" + node.getNodeName() + "=" + node.getNodeValue()).getBytes(charsetName));
        } else if (node.getNodeType() == 3) {
            outputStream.write(node.getNodeValue().getBytes(charsetName));
        } else {
            throw new SimplePrettyPrinterException("Cannot pretty print node type " + node.getNodeType());
        }
        return new String(outputStream.toByteArray(), charsetName).trim();
    }
}

