/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.io;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import ro.sync.basic.io.NonCloseableReader;
import ro.sync.basic.io.StringBuilderReader;

public class NonCloseableStringReader
extends NonCloseableReader {
    private Reader reader;
    private String content;
    private StringBuilder contentBuffer;

    public NonCloseableStringReader(String inputContent) {
        this.reader = new StringReader(inputContent);
        this.content = inputContent;
    }

    public NonCloseableStringReader(StringBuilder inputBuffer) {
        this.reader = new StringBuilderReader(inputBuffer);
        this.contentBuffer = inputBuffer;
    }

    @Override
    public void reset() throws IOException {
        this.reader.reset();
    }

    @Override
    public void rewind() {
        this.reader = this.content != null ? new StringReader(this.content) : new StringBuilderReader(this.contentBuffer);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.reader.read(cbuf, off, len);
    }

    @Override
    public int read() throws IOException {
        return this.reader.read();
    }

    @Override
    public long skip(long ns) throws IOException {
        return this.reader.skip(ns);
    }

    @Override
    public boolean ready() throws IOException {
        return this.reader.ready();
    }

    @Override
    public boolean markSupported() {
        return this.reader.markSupported();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.reader.read(cbuf);
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.reader.mark(readAheadLimit);
    }
}

