/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.html;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ro.sync.basic.html.HTMLEntity;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.basic.xml.dom.LocationDomParser;

public class HTMLEntitiesRepository {
    private static final Logger logger = LoggerFactory.getLogger((String)HTMLEntitiesRepository.class.getName());
    private static HTMLEntitiesRepository instance = null;
    private final List<HTMLEntity> unmodifiableEntities;
    private final List<HTMLEntity> entities2Search = new ArrayList<HTMLEntity>();

    public static HTMLEntitiesRepository getInstance() {
        if (instance == null) {
            instance = new HTMLEntitiesRepository();
        }
        return instance;
    }

    private HTMLEntitiesRepository() {
        URL sampleWithXInclude = this.getClass().getClassLoader().getResource("htmlEntities.xml");
        LocationDomParser parser = new LocationDomParser();
        ArrayList<HTMLEntity> toAdd = new ArrayList<HTMLEntity>();
        try {
            parser.parse(sampleWithXInclude.toExternalForm());
            Document doc = parser.getDocument();
            NodeList childNodes = doc.getDocumentElement().getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i);
                if (node.getNodeType() != 1) continue;
                Element entity = (Element)node;
                this.addEntity(toAdd, (Element)entity.getElementsByTagName("name").item(0), (Element)entity.getElementsByTagName("dec").item(0));
            }
        }
        catch (IOException | SAXException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.unmodifiableEntities = Collections.unmodifiableList(toAdd);
    }

    private void addEntity(List<HTMLEntity> entities, Element name, Element decimal) {
        if (name != null && decimal != null) {
            try {
                String rawName = name.getTextContent().trim();
                ArrayList<CallSite> names = new ArrayList<CallSite>();
                if (rawName.indexOf(44) != -1) {
                    StringTokenizer stk = new StringTokenizer(rawName, ", ", false);
                    while (stk.hasMoreTokens()) {
                        names.add((CallSite)((Object)("&" + stk.nextToken() + ";")));
                    }
                } else {
                    names.add((CallSite)((Object)("&" + rawName + ";")));
                }
                if (!names.isEmpty()) {
                    entities.add(new HTMLEntity(names.toArray(new String[names.size()]), NumberParserUtil.parseInt(decimal.getTextContent().trim())));
                }
            }
            catch (DOMException | NumberFormatException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public int accepts(char c, int pos) {
        Iterator<HTMLEntity> iter = this.entities2Search.iterator();
        while (iter.hasNext()) {
            HTMLEntity entity = iter.next();
            if (!entity.accepts(c, pos)) {
                iter.remove();
                continue;
            }
            if (';' != c) continue;
            return entity.getCode();
        }
        return this.entities2Search.isEmpty() ? -1 : 0;
    }

    public void reset() {
        this.entities2Search.clear();
        for (HTMLEntity htmlEntity : this.unmodifiableEntities) {
            htmlEntity.reset();
            this.entities2Search.add(htmlEntity);
        }
    }
}

