/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.archive;

import de.schlichtherle.io.ArchiveException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.archive.ArchiveLock;
import ro.sync.basic.util.URLUtil;

public class BasicArchiveUtil {
    private static ArchiveLock lock = ArchiveLock.getInstance();
    private static final Logger logger = LoggerFactory.getLogger((String)BasicArchiveUtil.class.getName());

    public static boolean isArchiveEntry(File file) {
        if (file instanceof de.schlichtherle.io.File) {
            de.schlichtherle.io.File topLevelArchive = ((de.schlichtherle.io.File)file).getTopLevelArchive();
            return topLevelArchive != null && topLevelArchive.getDelegate().exists() && topLevelArchive.getDelegate().isFile();
        }
        return false;
    }

    public static File archiveURLToFile(URL url) throws IOException {
        if (url != null && "zip".equals(url.getProtocol())) {
            String zipPath = url.getPath();
            URL fileURL = new URL(zipPath);
            if ("file".equals(fileURL.getProtocol())) {
                File parent;
                String localZipPath = URLUtil.uncorrect(fileURL.getFile());
                File localZipFile = new File(localZipPath);
                ArrayList<String> prevChildren = new ArrayList<String>();
                prevChildren.add(localZipFile.getName());
                File child = localZipFile;
                for (parent = localZipFile.getParentFile(); parent != null && !parent.exists(); parent = parent.getParentFile()) {
                    prevChildren.add(parent.getName());
                    child = parent;
                }
                if (parent != null && child.getName().endsWith("!")) {
                    int start;
                    String archiveName = child.getName();
                    archiveName = archiveName.substring(0, archiveName.length() - 1);
                    StringBuffer pathInArchive = new StringBuffer();
                    for (int i = start = prevChildren.size() - 2; i >= 0; --i) {
                        if (i != start) {
                            pathInArchive.append("/");
                        }
                        pathInArchive.append((String)prevChildren.get(i));
                    }
                    de.schlichtherle.io.File archiveFile = new de.schlichtherle.io.File(parent, archiveName);
                    de.schlichtherle.io.File archiveEntryFile = new de.schlichtherle.io.File((File)archiveFile, pathInArchive.toString());
                    return archiveEntryFile;
                }
                throw new IOException("Could not determine the archive path from the URL: " + URLUtil.getDescription(url));
            }
            throw new IOException("Writing is supported only for local archives.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unmount(File archiveFile) {
        ArchiveLock archiveLock = lock;
        synchronized (archiveLock) {
            try {
                if (archiveFile != null) {
                    de.schlichtherle.io.File topLevelArchive;
                    if (archiveFile instanceof de.schlichtherle.io.File && (topLevelArchive = ((de.schlichtherle.io.File)archiveFile).getTopLevelArchive()) != null) {
                        de.schlichtherle.io.File.umount((de.schlichtherle.io.File)topLevelArchive);
                    }
                } else {
                    de.schlichtherle.io.File.umount();
                }
            }
            catch (ArchiveException e) {
                logger.warn("Error when umount the last archive: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

