/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.publishing.template.fragment;

import com.oxygenxml.publishing.template.AntLogger;
import com.oxygenxml.publishing.template.AntPropertiesProvider;
import com.oxygenxml.publishing.template.fragment.CommentedScriptNode;
import com.oxygenxml.publishing.template.fragment.HTMLFragmentFileInfo;
import com.oxygenxml.publishing.template.fragment.WellFormedException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.HtmlNode;
import org.htmlcleaner.SimpleXmlSerializer;
import org.htmlcleaner.TagNode;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.sync.basic.io.FileSystemUtilBasic;
import ro.sync.basic.io.IOUtil;

public class HtmlFragmentConverter {
    private static final String WEBHELP_HTML_FRAGMENTS_CONVERTER_PROPERTIES_FILE_PROPERTY = "webhelp.html.fragments.converter.properties.file";
    private static final String WEBHELP_ENABLE_HTML_FRAGMENTS_PROCESSING_PROPERTY = "webhelp.enable.html.fragments.cleanup";
    private AntLogger antLogger;
    private boolean isXMLWellFormedConversionEnabled;
    private File fragmentsTempFolder;
    private AntPropertiesProvider propertiesProvider;
    private CleanerProperties cleanerProperties;

    public HtmlFragmentConverter(AntPropertiesProvider propertiesProvider, AntLogger antLogger, File tempFileFolder) {
        this.propertiesProvider = propertiesProvider;
        this.antLogger = antLogger;
        this.fragmentsTempFolder = new File(tempFileFolder, "whr-html-fragments");
        this.fragmentsTempFolder.mkdirs();
        this.isXMLWellFormedConversionEnabled = propertiesProvider.getBooleanProperty(WEBHELP_ENABLE_HTML_FRAGMENTS_PROCESSING_PROPERTY).orElse(true);
        antLogger.log(MessageFormat.format("HTML Fragments conversion to Well Formed XML content is ''{0}''", this.isXMLWellFormedConversionEnabled ? "enabled" : "disabled"));
        this.cleanerProperties = this.initHtmlCleanerProperties();
    }

    public HTMLFragmentFileInfo processFileFragment(String fragmentId, File htmlFragmentFile) {
        HTMLFragmentFileInfo hTMLFragmentFileInfo;
        String originalFilePath = htmlFragmentFile.getAbsolutePath();
        FileInputStream fragmentInputStream = new FileInputStream(htmlFragmentFile);
        try {
            byte[] byteArray = IOUtil.readBytes((InputStream)fragmentInputStream);
            HTMLFragmentFileInfo fragmentInfo = this.process(fragmentId, byteArray);
            if (fragmentInfo == null) {
                fragmentInfo = new HTMLFragmentFileInfo(fragmentId, htmlFragmentFile.getAbsolutePath());
            }
            hTMLFragmentFileInfo = fragmentInfo;
        }
        catch (Throwable byteArray) {
            try {
                try {
                    fragmentInputStream.close();
                }
                catch (Throwable throwable) {
                    byteArray.addSuppressed(throwable);
                }
                throw byteArray;
            }
            catch (IOException e) {
                String message = MessageFormat.format("Cannot read file associated with ''{0}'' HTML fragment. File path : {1}", fragmentId, originalFilePath);
                throw new BuildException(message, (Throwable)e);
            }
        }
        fragmentInputStream.close();
        return hTMLFragmentFileInfo;
    }

    public HTMLFragmentFileInfo processHtmlFragmentParameter(String fragmentId, String parameterValue) {
        if (HtmlFragmentConverter.isFilePath(parameterValue)) {
            return this.processFileFragment(fragmentId, new File(parameterValue));
        }
        return this.processStringFragment(fragmentId, parameterValue);
    }

    private HTMLFragmentFileInfo processStringFragment(String fragmentId, String htmlFragmentValue) {
        byte[] fragmentBytes = htmlFragmentValue.getBytes();
        HTMLFragmentFileInfo fragmentFileInfo = this.process(fragmentId, fragmentBytes);
        if (fragmentFileInfo == null) {
            try {
                File newFile = this.createTemporaryFile(fragmentId);
                try (ByteArrayInputStream is = new ByteArrayInputStream(fragmentBytes);
                     FileOutputStream os = new FileOutputStream(newFile);){
                    FileSystemUtilBasic.copyInputStreamToOutputStream((InputStream)is, (OutputStream)os, (boolean)true);
                    fragmentFileInfo = new HTMLFragmentFileInfo(fragmentId, newFile.getAbsolutePath());
                }
            }
            catch (IOException io) {
                this.cannotWriteStringFragmentToFile(fragmentId, io);
            }
        }
        return fragmentFileInfo;
    }

    private static boolean isFilePath(String htmlFragmentValue) {
        boolean isFilePath = false;
        try {
            Path path = Paths.get(htmlFragmentValue, new String[0]);
            if (path.isAbsolute()) {
                isFilePath = path.toFile().exists();
            }
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
        return isFilePath;
    }

    private HTMLFragmentFileInfo process(String fragmentId, byte[] fragmentBytes) {
        HTMLFragmentFileInfo fragmentFileInfo = null;
        try {
            this.checkWellFormed(fragmentBytes, fragmentId);
        }
        catch (WellFormedException e) {
            if (this.isXMLWellFormedConversionEnabled) {
                try {
                    File newFile = this.createTemporaryFile(fragmentId);
                    try (ByteArrayInputStream is = new ByteArrayInputStream(fragmentBytes);
                         FileOutputStream os = new FileOutputStream(newFile);){
                        this.convertToWellFormedXML(is, os);
                        fragmentFileInfo = new HTMLFragmentFileInfo(fragmentId, newFile.getAbsolutePath());
                    }
                }
                catch (IOException io) {
                    this.cannotConvert(fragmentId, io);
                }
            }
            throw new BuildException(MessageFormat.format("HTML Fragment with ID ''{0}'' is not XML well-formed. \nReason: {1}", fragmentId, e.getMessage()), (Throwable)e);
        }
        return fragmentFileInfo;
    }

    private File createTemporaryFile(String fragmentId) throws IOException {
        File newFile = new File(this.fragmentsTempFolder, fragmentId.replace('.', '_') + ".xml");
        boolean created = newFile.createNewFile();
        this.antLogger.log("Creating file " + newFile.getAbsolutePath() + " for fragment " + fragmentId + ". Created: " + created);
        return newFile;
    }

    private void cannotConvert(String fragmentId, Exception e) {
        throw new BuildException(MessageFormat.format("The HTML fragment with ID ''{0}''cannot be converted to well-formed XML. \nReason: {1}", fragmentId, e.getMessage()), (Throwable)e);
    }

    private void cannotWriteStringFragmentToFile(String fragmentId, Exception e) {
        throw new BuildException(MessageFormat.format("The HTML fragment with ID ''{0}''cannot be written to temporary file. \nReason: {1}", fragmentId, e.getMessage()), (Throwable)e);
    }

    private void checkWellFormed(byte[] fragmentBytes, String fragmentId) throws WellFormedException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(fragmentBytes);){
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            dBuilder.setErrorHandler(new DefaultHandler());
            dBuilder.parse(is);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            this.antLogger.warn(MessageFormat.format("HTML Fragment with ID ''{0}'' is not XML well-formed. \nReason: {1}", fragmentId, e.getMessage()));
            throw new WellFormedException(e);
        }
    }

    private void convertToWellFormedXML(InputStream is, OutputStream os) throws IOException {
        HtmlCleaner htmlCleaner = new HtmlCleaner(this.cleanerProperties);
        TagNode tagNode = htmlCleaner.clean(is);
        this.fixHtmlStructure(tagNode);
        SimpleXmlSerializer xmlSerializer = new SimpleXmlSerializer(this.cleanerProperties);
        xmlSerializer.writeToStream(tagNode, os, StandardCharsets.UTF_8.name());
        os.flush();
    }

    private void fixHtmlStructure(TagNode tagNode) {
        tagNode.traverse((parentTagNode, currentHtmlNode) -> {
            if (this.isScriptOrStyle(parentTagNode) && currentHtmlNode instanceof ContentNode && !(currentHtmlNode instanceof CommentNode)) {
                ContentNode contentNode = (ContentNode)currentHtmlNode;
                parentTagNode.insertChildBefore((HtmlNode)contentNode, (HtmlNode)new CommentedScriptNode(contentNode.getContent()));
                parentTagNode.removeChild((Object)contentNode);
            }
            return true;
        });
    }

    private boolean isScriptOrStyle(TagNode node) {
        return Optional.ofNullable(node).map(TagNode::getName).filter(name -> Stream.of("script", "style").anyMatch(tag -> tag.equalsIgnoreCase((String)name))).isPresent();
    }

    private CleanerProperties initHtmlCleanerProperties() {
        CleanerProperties props = new CleanerProperties();
        props.setTransResCharsToNCR(true);
        props.setKeepWhitespaceAndCommentsInHead(true);
        props.setAdvancedXmlEscape(true);
        props.setRecognizeUnicodeChars(false);
        props.setOmitDoctypeDeclaration(false);
        props.setIgnoreQuestAndExclam(false);
        props.setUseCdataForScriptAndStyle(false);
        if (this.isXMLWellFormedConversionEnabled) {
            this.applyUserConfigurationProperties(props);
        }
        return props;
    }

    private void applyUserConfigurationProperties(CleanerProperties props) {
        Properties properties = new Properties();
        this.propertiesProvider.getProperty(WEBHELP_HTML_FRAGMENTS_CONVERTER_PROPERTIES_FILE_PROPERTY).map(File::new).ifPresent(propsFile -> {
            try (FileReader reader = new FileReader((File)propsFile);){
                properties.load(reader);
            }
            catch (IOException e) {
                this.antLogger.warn(MessageFormat.format("Cannot load the HTML Fragment Converter properties (''{0}'') because: {1}", WEBHELP_HTML_FRAGMENTS_CONVERTER_PROPERTIES_FILE_PROPERTY, e));
            }
        });
        properties.stringPropertyNames().stream().forEach(key -> {
            String value = properties.getProperty((String)key);
            boolean booleanValue = Boolean.parseBoolean(value);
            switch (key) {
                case "advancedXmlEscape": {
                    props.setAdvancedXmlEscape(booleanValue);
                    break;
                }
                case "deserializeEntities": {
                    props.setDeserializeEntities(booleanValue);
                    break;
                }
                case "transResCharsToNCR": {
                    props.setTransResCharsToNCR(booleanValue);
                    break;
                }
                case "translateSpecialEntities": {
                    props.setTranslateSpecialEntities(booleanValue);
                    break;
                }
                case "transSpecialEntitiesToNCR": {
                    props.setTransSpecialEntitiesToNCR(booleanValue);
                    break;
                }
                case "recognizeUnicodeChars": {
                    props.setRecognizeUnicodeChars(booleanValue);
                    break;
                }
                case "omitUnknownTags": {
                    props.setOmitUnknownTags(booleanValue);
                    break;
                }
                case "treatUnknTagsAsContent": {
                    props.setTreatUnknownTagsAsContent(booleanValue);
                    break;
                }
                case "omitDeprTags": {
                    props.setOmitDeprecatedTags(booleanValue);
                    break;
                }
                case "treatDeprTagsAsContent": {
                    props.setTreatDeprecatedTagsAsContent(booleanValue);
                    break;
                }
                case "omitCdataOutsideScriptAndStyle": {
                    props.setOmitCdataOutsideScriptAndStyle(booleanValue);
                    break;
                }
                case "omitComments": {
                    props.setOmitComments(booleanValue);
                    break;
                }
                case "omitXmlDeclaration": {
                    props.setOmitXmlDeclaration(booleanValue);
                    break;
                }
                case "omitDoctypeDeclaration": {
                    props.setOmitDoctypeDeclaration(booleanValue);
                    break;
                }
                case "omitEnvelope": {
                    props.setOmitHtmlEnvelope(booleanValue);
                    break;
                }
                case "useEmptyElementTags": {
                    props.setUseEmptyElementTags(booleanValue);
                    break;
                }
                case "allowMultiWordAttributes": {
                    props.setAllowMultiWordAttributes(booleanValue);
                    break;
                }
                case "allowHtmlInsideAttributes": {
                    props.setAllowHtmlInsideAttributes(booleanValue);
                    break;
                }
                case "ignoreQuestAndExclam": {
                    props.setIgnoreQuestAndExclam(booleanValue);
                    break;
                }
                case "namespacesAware": {
                    props.setNamespacesAware(booleanValue);
                    break;
                }
                case "hyphenReplacement": {
                    props.setHyphenReplacementInComment(value);
                    break;
                }
                case "pruneTags": {
                    props.setPruneTags(value);
                    break;
                }
                case "booleanAtts": {
                    props.setBooleanAttributeValues(value);
                    break;
                }
                case "useCdata": {
                    props.setUseCdataForScriptAndStyle(booleanValue);
                    break;
                }
                default: {
                    this.antLogger.warn(MessageFormat.format("Skipping HTML Fragment converter property: {0} = {1}", key, value));
                }
            }
        });
    }

    protected CleanerProperties getCleanerProperties() {
        return this.cleanerProperties;
    }
}

