/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.publishing.template.binding;

import com.oxygenxml.publishing.template.ErrorPublishingTemplateType;
import com.oxygenxml.publishing.template.ITemplateValidationListener;
import com.oxygenxml.publishing.template.PublishingTemplateLoadException;
import com.oxygenxml.publishing.template.binding.CSSFile;
import com.oxygenxml.publishing.template.binding.FaviconFile;
import com.oxygenxml.publishing.template.binding.HTMLFragment;
import com.oxygenxml.publishing.template.binding.HTMLPageTemplate;
import com.oxygenxml.publishing.template.binding.JsModule;
import com.oxygenxml.publishing.template.binding.LogoFile;
import com.oxygenxml.publishing.template.binding.PublishingTemplate;
import com.oxygenxml.publishing.template.binding.PublishingTemplateType;
import com.oxygenxml.publishing.template.binding.XSLTExtensionPoint;
import com.oxygenxml.publishing.template.i18n.MessagesBundleProvider;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="publishing-template", namespace="")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ZIPPublishingTemplate
extends PublishingTemplate {
    private static ResourceBundle messages = MessagesBundleProvider.getBundle();
    private String descriptorRootDirName;

    public ZIPPublishingTemplate() {
    }

    public ZIPPublishingTemplate(PublishingTemplate source) {
        super(source);
    }

    @Override
    public String toString() {
        return "ZIPPublishingTemplate [name=" + this.name + "]";
    }

    @Override
    public void validatePackageContent(ITemplateValidationListener templateValidationListener) throws PublishingTemplateLoadException {
        try (ZipFile zipFile = new ZipFile(this.packageRoot);){
            String em;
            String em2;
            String imagePath;
            if (this.webhelpTemplateInfo != null) {
                JsModule scriptFile;
                FaviconFile favIconFile;
                String em3;
                List<HTMLFragment> htmnlFragments;
                List<XSLTExtensionPoint> xsltExtensionPoints;
                if (!templateValidationListener.shouldIgnoreUiEvents()) {
                    if (this.webhelpTemplateInfo.getPreviewImage() != null) {
                        imagePath = this.webhelpTemplateInfo.getPreviewImage().getImagePath();
                        this.reportProblem(this.checkRelativePath(zipFile, imagePath, "The_preview_image_does_not_exist"), templateValidationListener, true, ErrorPublishingTemplateType.WEBHELP);
                    } else {
                        this.reportProblem(messages.getString("No_preview_image_in_template_descriptor"), templateValidationListener, true, ErrorPublishingTemplateType.WEBHELP);
                    }
                }
                if (this.webhelpTemplateInfo.hasPageTemplates()) {
                    String htmlTemplatesWarning = messages.getString("Verify_html_page_templates");
                    HTMLPageTemplate pageTemplate = this.webhelpTemplateInfo.getHTMLPageTemplate("main");
                    if (pageTemplate != null) {
                        String em4 = this.checkRelativePath(zipFile, pageTemplate.getFilePath(), "Main_layout_page_missing");
                        this.reportProblem(em4, templateValidationListener, false, ErrorPublishingTemplateType.WEBHELP);
                    } else {
                        this.reportProblem(messages.getString("Main_layout_not_defined") + htmlTemplatesWarning, templateValidationListener, false, ErrorPublishingTemplateType.WEBHELP);
                    }
                    pageTemplate = this.webhelpTemplateInfo.getHTMLPageTemplate("search");
                    if (pageTemplate != null) {
                        this.reportProblem(this.checkRelativePath(zipFile, pageTemplate.getFilePath(), "Search_layout_page_missing"), templateValidationListener, false, ErrorPublishingTemplateType.WEBHELP);
                    } else {
                        this.reportProblem(messages.getString("Search_layout_not_defined") + " " + htmlTemplatesWarning, templateValidationListener, false, ErrorPublishingTemplateType.WEBHELP);
                    }
                    pageTemplate = this.webhelpTemplateInfo.getHTMLPageTemplate("topic");
                    if (pageTemplate != null) {
                        this.reportProblem(this.checkRelativePath(zipFile, pageTemplate.getFilePath(), "Topic_layout_page_missing"), templateValidationListener, false, ErrorPublishingTemplateType.WEBHELP);
                    } else {
                        this.reportProblem(messages.getString("Topic_layout_not_defined") + " " + htmlTemplatesWarning, templateValidationListener, false, ErrorPublishingTemplateType.WEBHELP);
                    }
                    pageTemplate = this.webhelpTemplateInfo.getHTMLPageTemplate("index-terms");
                    if (pageTemplate != null) {
                        this.reportProblem(this.checkRelativePath(zipFile, pageTemplate.getFilePath(), "Indexterms_layout_page_missing"), templateValidationListener, false, ErrorPublishingTemplateType.WEBHELP);
                    } else {
                        this.reportProblem(messages.getString("Indexterms_layout_not_defined") + " " + htmlTemplatesWarning, templateValidationListener, false, ErrorPublishingTemplateType.WEBHELP);
                    }
                }
                if ((xsltExtensionPoints = this.webhelpTemplateInfo.getXSLTExtensionPoints()) != null && !xsltExtensionPoints.isEmpty()) {
                    for (XSLTExtensionPoint xsltExtensionPoint : xsltExtensionPoints) {
                        em2 = this.checkRelativePath(zipFile, xsltExtensionPoint.getFilePath(), "Xslt_extension_missing");
                        this.reportProblem(em2, templateValidationListener, false, ErrorPublishingTemplateType.WEBHELP);
                    }
                }
                if ((htmnlFragments = this.webhelpTemplateInfo.getHTMLFragments()) != null && !htmnlFragments.isEmpty()) {
                    for (HTMLFragment htmlFragment : htmnlFragments) {
                        this.reportProblem(this.checkRelativePath(zipFile, htmlFragment.getFilePath(), "Html_fragment_missing"), templateValidationListener, true, ErrorPublishingTemplateType.WEBHELP);
                    }
                }
                List<CSSFile> cssFile = this.webhelpTemplateInfo.getWebhelpResources().getCssFiles();
                for (CSSFile cssF : cssFile) {
                    em3 = this.checkRelativePath(zipFile, cssF.getFilePath(), "CSS_file_missing");
                    this.reportProblem(em3, templateValidationListener, true, ErrorPublishingTemplateType.WEBHELP);
                }
                LogoFile logoFile = this.webhelpTemplateInfo.getWebhelpResources().getLogoFile();
                if (logoFile != null) {
                    em = this.checkRelativePath(zipFile, logoFile.getFilePath(), "Logo_file_missing");
                    this.reportProblem(em, templateValidationListener, true, ErrorPublishingTemplateType.WEBHELP);
                }
                if ((favIconFile = this.webhelpTemplateInfo.getWebhelpResources().getFaviconFile()) != null) {
                    em3 = this.checkRelativePath(zipFile, favIconFile.getFilePath(), "Favicon_file_missing");
                    this.reportProblem(em3, templateValidationListener, true, ErrorPublishingTemplateType.WEBHELP);
                }
                if ((scriptFile = this.webhelpTemplateInfo.getWebhelpResources().getJsModule()) != null) {
                    String em5 = this.checkRelativePath(zipFile, scriptFile.getFilePath(), "Js_module_file_missing");
                    this.reportProblem(em5, templateValidationListener, true, ErrorPublishingTemplateType.WEBHELP);
                }
            }
            if (this.pdfTemplateInfo != null) {
                List<XSLTExtensionPoint> xsltExtensionPoints;
                List<CSSFile> cssFile;
                if (!templateValidationListener.shouldIgnoreUiEvents()) {
                    if (this.pdfTemplateInfo.getPreviewImage() != null) {
                        imagePath = this.pdfTemplateInfo.getPreviewImage().getImagePath();
                        this.reportProblem(this.checkRelativePath(zipFile, imagePath, "Pdf_the_preview_image_does_not_exist"), templateValidationListener, true, ErrorPublishingTemplateType.PDF);
                    } else {
                        this.reportProblem(messages.getString("Pdf_no_preview_image_in_template_descriptor"), templateValidationListener, true, ErrorPublishingTemplateType.PDF);
                    }
                }
                if ((cssFile = this.pdfTemplateInfo.getCssFiles()) != null) {
                    for (CSSFile cssF : cssFile) {
                        em2 = this.checkRelativePath(zipFile, cssF.getFilePath(), "Pdf_CSS_file_missing");
                        this.reportProblem(em2, templateValidationListener, true, ErrorPublishingTemplateType.PDF);
                    }
                }
                if ((xsltExtensionPoints = this.pdfTemplateInfo.getXSLTExtensionPoints()) != null && !xsltExtensionPoints.isEmpty()) {
                    for (XSLTExtensionPoint xsltExtensionPoint : xsltExtensionPoints) {
                        em = this.checkRelativePath(zipFile, xsltExtensionPoint.getFilePath(), "Pdf_Xslt_extension_missing");
                        this.reportProblem(em, templateValidationListener, false, ErrorPublishingTemplateType.PDF);
                    }
                }
            }
        }
        catch (IOException e) {
            String message = "Cannot open the zip template package: " + this.packageRoot.getAbsolutePath();
            this.reportProblem(message, templateValidationListener, false, ErrorPublishingTemplateType.COMMON);
            throw new PublishingTemplateLoadException(message, e);
        }
    }

    private String checkRelativePath(ZipFile zipFile, String relPath, String errorTag) {
        ZipEntry entry;
        String errorMessage = null;
        if (this.descriptorRootDirName != null) {
            relPath = this.descriptorRootDirName + "/" + (String)relPath;
        }
        if ((entry = zipFile.getEntry((String)relPath)) == null) {
            errorMessage = MessageFormat.format(messages.getString(errorTag), relPath);
        }
        return errorMessage;
    }

    @Override
    public PublishingTemplateType getType() {
        return PublishingTemplateType.ARCHIVE;
    }

    @Override
    public void setDescriptorRelativePath(String descriptorRelPath) {
        super.setDescriptorRelativePath(descriptorRelPath);
        String[] dirNames = descriptorRelPath.split("/");
        if (dirNames != null && dirNames.length == 2) {
            this.descriptorRootDirName = dirNames[0];
        }
    }

    public String getDescriptorRootDirName() {
        return this.descriptorRootDirName;
    }
}

