/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.publishing.template.binding;

import com.oxygenxml.publishing.template.ErrorPublishingTemplateType;
import com.oxygenxml.publishing.template.ITemplateValidationListener;
import com.oxygenxml.publishing.template.ProblemType;
import com.oxygenxml.publishing.template.PublishingTemplateLoadException;
import com.oxygenxml.publishing.template.TemplateValidationEvent;
import com.oxygenxml.publishing.template.binding.Author;
import com.oxygenxml.publishing.template.binding.PDFTemplateInfo;
import com.oxygenxml.publishing.template.binding.PublishingTemplateConstants;
import com.oxygenxml.publishing.template.binding.PublishingTemplateType;
import com.oxygenxml.publishing.template.binding.WebHelpTemplateInfo;
import java.io.File;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"name", "description", "developer", "webhelpTemplateInfo", "pdfTemplateInfo", "others"})
public abstract class PublishingTemplate
extends PublishingTemplateConstants {
    @XmlElement(name="name", namespace="")
    String name;
    @XmlElement(name="description", namespace="")
    private String description;
    @XmlElement(name="author", namespace="")
    private Author developer;
    @XmlElement(name="webhelp", namespace="")
    protected WebHelpTemplateInfo webhelpTemplateInfo;
    @XmlElement(name="pdf", namespace="")
    protected PDFTemplateInfo pdfTemplateInfo;
    @XmlAnyElement(lax=true)
    public Object[] others;
    @XmlTransient
    protected File packageRoot;
    @XmlTransient
    private String descriptorRelPath;

    protected PublishingTemplate() {
    }

    public PublishingTemplate(PublishingTemplate source) {
        this.name = source.name;
        this.description = source.description;
        if (source.developer != null) {
            this.developer = new Author(source.developer);
        }
        if (source.webhelpTemplateInfo != null) {
            this.webhelpTemplateInfo = new WebHelpTemplateInfo(source.webhelpTemplateInfo);
        }
        if (source.pdfTemplateInfo != null) {
            this.pdfTemplateInfo = new PDFTemplateInfo(source.pdfTemplateInfo);
        }
        if (source.others != null) {
            this.others = Arrays.copyOf(source.others, source.others.length);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Author getDeveloper() {
        return this.developer;
    }

    public WebHelpTemplateInfo getWebhelpTemplateInfo() {
        return this.webhelpTemplateInfo;
    }

    public PDFTemplateInfo getPDFTemplateInfo() {
        return this.pdfTemplateInfo;
    }

    public void setDescriptorRelativePath(String descriptorRelPath) {
        this.descriptorRelPath = descriptorRelPath;
    }

    public String getDescriptorRelativePath() {
        return this.descriptorRelPath;
    }

    public abstract void validatePackageContent(ITemplateValidationListener var1) throws PublishingTemplateLoadException;

    public File getPackageRoot() {
        return this.packageRoot;
    }

    public void setPackageRoot(File rootFolder) {
        this.packageRoot = rootFolder;
    }

    protected void reportProblem(String message, ITemplateValidationListener validationListener, boolean isWarning, ErrorPublishingTemplateType publishingFormat) {
        if (message != null && validationListener != null) {
            ProblemType type = isWarning ? ProblemType.WARNING : ProblemType.ERROR;
            String templatePackageRootPath = null;
            if (this.packageRoot != null) {
                templatePackageRootPath = this.packageRoot.getAbsolutePath();
            }
            TemplateValidationEvent templateValidationEv = new TemplateValidationEvent(this.name, templatePackageRootPath, this.getDescriptorRelativePath(), this.developer != null ? this.developer.getName() : null, this.developer != null ? this.developer.getEmail() : null, this.developer != null ? this.developer.getOrganization() : null, this.developer != null ? this.developer.getOrganizationUrl() : null, type, publishingFormat, message, null);
            if (isWarning) {
                validationListener.warning(templateValidationEv);
            } else {
                validationListener.error(templateValidationEv);
            }
        }
    }

    public abstract PublishingTemplateType getType();

    public void setName(String templateName) {
        this.name = templateName;
    }

    public void setDescription(String templateDescription) {
        this.description = templateDescription;
    }

    public void setWebhelpTemplateInfo(WebHelpTemplateInfo webhelpTemplateInfo) {
        this.webhelpTemplateInfo = webhelpTemplateInfo;
    }

    public void setPDFTemplateInfo(PDFTemplateInfo pdfTemplateInfo) {
        this.pdfTemplateInfo = pdfTemplateInfo;
    }

    public String toString() {
        return String.format("PublishingTemplate [name=%s, description=%s, developer=%s, webhelpTemplateInfo=%s]", this.name, this.description, this.developer, this.webhelpTemplateInfo);
    }
}

