/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.publishing.template.binding;

import com.oxygenxml.publishing.template.binding.CSSFile;
import com.oxygenxml.publishing.template.binding.CloneUtil;
import com.oxygenxml.publishing.template.binding.Parameter;
import com.oxygenxml.publishing.template.binding.PreviewImage;
import com.oxygenxml.publishing.template.binding.Tag;
import com.oxygenxml.publishing.template.binding.XSLTExtensionPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class PDFTemplateInfo {
    @XmlElement(name="preview-image", namespace="")
    private PreviewImage previewImage;
    @XmlElementWrapper(name="tags", namespace="")
    @XmlElement(name="tag", namespace="")
    private List<Tag> tags;
    @XmlElementWrapper(name="parameters", namespace="")
    @XmlElement(name="parameter", namespace="")
    private List<Parameter> paramsList;
    @XmlElementWrapper(name="resources")
    @XmlElement(name="css", namespace="")
    private List<CSSFile> cssFiles;
    @XmlElementWrapper(name="xslt")
    @XmlElement(name="extension")
    private List<XSLTExtensionPoint> xslExtensionPoints;
    @XmlElement(name="online-preview-url", namespace="")
    private String onlinePreviewUrl;
    @XmlAnyElement(lax=true)
    public Object[] others;

    public PDFTemplateInfo() {
    }

    public PDFTemplateInfo(PDFTemplateInfo source) {
        if (source.previewImage != null) {
            this.previewImage = new PreviewImage(source.previewImage);
        }
        this.tags = CloneUtil.copyTags(source.tags);
        this.paramsList = CloneUtil.copyParameters(source.paramsList);
        this.xslExtensionPoints = CloneUtil.copyXsltExtensionPoints(source.xslExtensionPoints);
        if (source.cssFiles != null) {
            this.cssFiles = CloneUtil.copyCssFiles(source.cssFiles);
        }
        this.onlinePreviewUrl = source.onlinePreviewUrl;
        if (source.others != null) {
            this.others = Arrays.copyOf(source.others, source.others.length);
        }
    }

    public PreviewImage getPreviewImage() {
        return this.previewImage;
    }

    public void setPreviewImage(PreviewImage previewImage) {
        this.previewImage = previewImage;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public List<CSSFile> getCssFiles() {
        return this.cssFiles;
    }

    public void setCssFiles(List<CSSFile> cssFiles) {
        this.cssFiles = cssFiles;
    }

    public List<XSLTExtensionPoint> getXSLTExtensionPoints() {
        return this.xslExtensionPoints;
    }

    public void setXslExtensionPoints(List<XSLTExtensionPoint> xslExtensionPoints) {
        this.xslExtensionPoints = xslExtensionPoints;
    }

    public String getOnlinePreviewUrl() {
        return this.onlinePreviewUrl;
    }

    public void setOnlinePreviewUrl(String onlinePreviewUrl) {
        this.onlinePreviewUrl = onlinePreviewUrl;
    }

    public void setParamsList(List<Parameter> paramsList) {
        this.paramsList = paramsList;
    }

    public List<Parameter> getParamsList() {
        return this.paramsList;
    }

    public void addParameters(List<Parameter> parameters) {
        if (parameters != null) {
            if (this.paramsList == null) {
                this.paramsList = new ArrayList<Parameter>();
            }
            this.paramsList.addAll(parameters);
        }
    }

    public void removeParameter(String name) {
        if (this.paramsList != null && name != null) {
            this.paramsList.removeIf(p -> name.equals(p.getName()));
        }
    }
}

