/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.publishing.template;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Echo;
import ro.sync.licensemanager.base.LicenseCheckerWithOxygenParent;

public class AntLicenseValidationHandler
implements LicenseCheckerWithOxygenParent.LicenseValidationHandler {
    private static final String ERRORS_DELIMITER = "\n\n";
    private Project antProject;
    private List<String> errorsList = new ArrayList<String>(0);

    public AntLicenseValidationHandler(Project antProject) {
        this.antProject = antProject;
    }

    public void error(String message) {
        this.errorsList.add(message);
    }

    public void info(String message) {
        this.antProject.log(message);
    }

    public void warn(String message) {
        Echo echo = new Echo();
        echo.setProject(this.antProject);
        echo.setMessage(message);
        echo.setTaskName("echo");
        echo.execute();
    }

    public void validationStarted() {
        this.errorsList.clear();
    }

    public void validationEnded() {
        if (this.hasErrors()) {
            throw new BuildException(this.getErrorMessage());
        }
    }

    private String getErrorMessage() {
        return this.errorsList.stream().collect(Collectors.joining(ERRORS_DELIMITER));
    }

    public boolean hasErrors() {
        return !this.errorsList.isEmpty();
    }
}

