/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.dita.antextensions.pdf.css;

import java.io.File;
import java.net.MalformedURLException;
import org.apache.tools.ant.Task;

public final class SetCssListProperties
extends Task {
    public void execute() {
        String cssList = this.createCssList();
        String[] arr = cssList.split(";");
        StringBuilder tmp = new StringBuilder();
        StringBuilder links = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i].length() <= 0) continue;
            tmp = tmp.append("@import '");
            links = links.append("<link rel='stylesheet' type='text/css' href='");
            String url = arr[i];
            if (!url.contains(":/") && !url.startsWith("file:")) {
                try {
                    url = new File(url).toURI().toURL().toString();
                }
                catch (MalformedURLException e) {
                    this.log("Cannot parse the URL " + url, 1);
                    url = "file:/".concat(arr[i]);
                }
            }
            url = url.replace("\\", "/");
            url = url.replace("'", "%27");
            tmp = tmp.append(url);
            tmp = tmp.append("';\n");
            links = links.append(url);
            links = links.append("' />\n");
        }
        this.getProject().setProperty("main.css.content", tmp.toString());
        this.getProject().setProperty("html5.css.links", links.toString());
    }

    private String createCssList() {
        StringBuilder cssList = new StringBuilder();
        if (this.getProject().getProperty("html5-transtype") != null) {
            cssList.append(this.getProject().getProperty("webhelp.topic.css")).append(';');
        }
        cssList.append(this.getProject().getProperty("dita.print.css")).append(';');
        if (this.getProject().getProperty("extension.css") != null) {
            cssList.append(this.getProject().getProperty("extension.css")).append(';');
        }
        if (this.getProject().getProperty("template.css.list") != null) {
            cssList.append(this.getProject().getProperty("template.css.list")).append(';');
        }
        cssList.append(this.getProject().getProperty("args.css"));
        return cssList.toString();
    }
}

