/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.indexer.stem;

import org.tartarus.snowball.ext.ArmenianStemmer;
import org.tartarus.snowball.ext.EnglishStemmer;
import org.tartarus.snowball.ext.FrenchStemmer;
import org.tartarus.snowball.ext.GermanStemmer;
import org.tartarus.snowball.ext.HungarianStemmer;
import org.tartarus.snowball.ext.IrishStemmer;
import org.tartarus.snowball.ext.ItalianStemmer;
import org.tartarus.snowball.ext.PorterStemmer;
import org.tartarus.snowball.ext.PortugueseStemmer;
import org.tartarus.snowball.ext.RomanianStemmer;
import org.tartarus.snowball.ext.RussianStemmer;
import org.tartarus.snowball.ext.SpanishStemmer;
import org.tartarus.snowball.ext.SwedishStemmer;
import org.tartarus.snowball.ext.TurkishStemmer;
import ro.sync.exml.indexer.stem.Stemmer;
import ro.sync.exml.indexer.stem.StemmerLanguageNotSupportedException;

public class SnowballStemmer
implements Stemmer {
    private org.tartarus.snowball.SnowballStemmer stemmer;

    public SnowballStemmer(String languageCode) throws StemmerLanguageNotSupportedException {
        if ("en".equals(languageCode)) {
            this.stemmer = new EnglishStemmer();
        } else if ("ar".equals(languageCode)) {
            this.stemmer = new ArmenianStemmer();
        } else if ("br".equals(languageCode)) {
            this.stemmer = new PorterStemmer();
        } else if ("de".equals(languageCode)) {
            this.stemmer = new GermanStemmer();
        } else if ("es".equals(languageCode)) {
            this.stemmer = new SpanishStemmer();
        } else if ("fr".equals(languageCode)) {
            this.stemmer = new FrenchStemmer();
        } else if ("ga".equals(languageCode)) {
            this.stemmer = new IrishStemmer();
        } else if ("hu".equals(languageCode)) {
            this.stemmer = new HungarianStemmer();
        } else if ("it".equals(languageCode)) {
            this.stemmer = new ItalianStemmer();
        } else if ("pt".equals(languageCode)) {
            this.stemmer = new PortugueseStemmer();
        } else if ("ro".equals(languageCode)) {
            this.stemmer = new RomanianStemmer();
        } else if ("ru".equals(languageCode)) {
            this.stemmer = new RussianStemmer();
        } else if ("sv".equals(languageCode)) {
            this.stemmer = new SwedishStemmer();
        } else if ("tr".equals(languageCode)) {
            this.stemmer = new TurkishStemmer();
        } else {
            throw new StemmerLanguageNotSupportedException();
        }
    }

    @Override
    public String stem(String in) {
        String out = in;
        this.stemmer.setCurrent(in);
        if (this.stemmer.stem()) {
            out = this.stemmer.getCurrent();
        }
        return out;
    }
}

