/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.indexer.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.SAXException;
import ro.sync.exml.indexer.parser.ElementClassPair;
import ro.sync.exml.indexer.parser.ReviewAwareContentHandler;
import ro.sync.exml.indexer.utils.BlankRemover;
import ro.sync.exml.indexer.utils.IndexedFileInfo;

class ShortDescriptorExtractor
extends ReviewAwareContentHandler {
    private String metaShortDesc = null;
    private boolean shortdescCaptured = false;
    private ArrayList<ElementClassPair> skippedElements;
    private int skipLevel = 0;

    public ShortDescriptorExtractor(IndexedFileInfo fileInfo) {
        super(fileInfo);
    }

    @Override
    public void startElementInternal(String uri, String localName, String qName, Map<String, String> atts) {
        boolean shouldSkipElement = this.shouldSkipElement(uri, localName, qName, atts);
        if (shouldSkipElement) {
            ++this.skipLevel;
        }
        if (this.skipLevel == 0) {
            if (!this.shortdescCaptured && this.isShortDescElem(qName, atts)) {
                this.buffer.setLength(0);
                this.setCaptureText(true);
            } else if (this.isShortDescMetaElem(qName, atts)) {
                this.metaShortDesc = atts.get("content");
            }
        }
    }

    @Override
    public void endElementInternal(String uri, String localName, String qName, Map<String, String> atts) {
        boolean shouldSkipElement = this.shouldSkipElement(uri, localName, qName, atts);
        if (shouldSkipElement) {
            --this.skipLevel;
        }
        if (this.skipLevel == 0 && this.isShortDescElem(qName, atts)) {
            this.shortdescCaptured = true;
            this.setCaptureText(false);
        }
    }

    boolean isShortDescElem(String qName, Map<String, String> atts) {
        String classAttr;
        boolean shortDesc = false;
        if (atts != null && (qName.equalsIgnoreCase("div") || qName.equalsIgnoreCase("p") || qName.equalsIgnoreCase("span")) && (classAttr = atts.get("class")) != null) {
            shortDesc = classAttr.equalsIgnoreCase("shortdesc") || classAttr.equalsIgnoreCase("summary");
        }
        return shortDesc;
    }

    boolean isShortDescMetaElem(String qName, Map<String, String> atts) {
        String nameAttr;
        boolean shortDesc = false;
        if (atts != null && qName.equalsIgnoreCase("meta") && (nameAttr = atts.get("name")) != null) {
            shortDesc = nameAttr.equalsIgnoreCase("description");
        }
        return shortDesc;
    }

    @Override
    public void endDocument() throws SAXException {
        String shortDesc = this.buffer.toString().trim();
        if (shortDesc.isEmpty() && this.metaShortDesc != null) {
            shortDesc = this.metaShortDesc.trim();
        }
        if (!(shortDesc = BlankRemover.rmWhiteSpace(shortDesc)).isEmpty()) {
            this.fileInfo.setShortdesc(shortDesc);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isCaptureText()) {
            this.buffer.append(ch, start, length);
        }
    }

    public void setElementsNotToIndex(ArrayList<ElementClassPair> elemClassPairs) {
        this.skippedElements = elemClassPairs;
    }

    boolean shouldSkipElement(String uri, String localName, String qName, Map<String, String> atts) {
        boolean skip = false;
        if (this.skippedElements != null) {
            Iterator<ElementClassPair> iterator = this.skippedElements.iterator();
            while (!skip && iterator.hasNext()) {
                ElementClassPair elementClassPair = iterator.next();
                if (!elementClassPair.elementName.equalsIgnoreCase(qName)) continue;
                if (elementClassPair.className != null && elementClassPair.className.trim().length() > 0) {
                    String classAttr;
                    if (atts == null || (classAttr = atts.get("class")) == null) continue;
                    skip = classAttr.contains(elementClassPair.className);
                    continue;
                }
                skip = true;
            }
        }
        return skip;
    }
}

