/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.indexer.js;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.indexer.js.JsFilesBuilder;
import ro.sync.exml.indexer.keywords.IKeywordsRepository;
import ro.sync.exml.indexer.keywords.KeywordsRepository;
import ro.sync.exml.indexer.score.ScoreRepository;
import ro.sync.exml.indexer.utils.IndexedFileInfo;

public class WebHelpClassicJsFilesBuilder
extends JsFilesBuilder {
    private static final Logger logger = LoggerFactory.getLogger((String)WebHelpClassicJsFilesBuilder.class.getName());

    @Override
    public void writeHTMLInfoList(String fileO, List<IndexedFileInfo> list, boolean doStem) {
        int i = 0;
        Iterator<IndexedFileInfo> it = null;
        if (list == null) {
            return;
        }
        if (fileO == null) {
            return;
        }
        it = list.iterator();
        try (FileOutputStream fOut = new FileOutputStream(fileO);
             BufferedOutputStream bout = new BufferedOutputStream(fOut);
             OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, "UTF-8");){
            out.write("fil = new Array();\n");
            while (it.hasNext()) {
                IndexedFileInfo tempInfo = it.next();
                String tempPath = tempInfo.getRelativePath().replace(File.separatorChar, '/');
                String tempTitle = tempInfo.getTitle();
                String tempShortdesc = tempInfo.getShortdesc();
                if (tempTitle != null) {
                    tempTitle = tempTitle.replaceAll("\\s+", " ");
                    tempTitle = this.escapeHtml(tempTitle);
                    tempTitle = this.escapeJavaScript(tempTitle);
                }
                if (tempShortdesc != null) {
                    tempShortdesc = this.escapeHtml(tempShortdesc);
                    tempShortdesc = this.escapeJavaScript(tempShortdesc);
                }
                if (tempShortdesc != null) {
                    Object stripNonAlphabeticalChars = this.stripNonAlphabeticalChars(tempShortdesc);
                    stripNonAlphabeticalChars = (String)stripNonAlphabeticalChars + "...";
                    out.write("fil[\"" + i + "\"]= \"" + tempPath + "@@@" + tempTitle + "@@@" + (String)stripNonAlphabeticalChars + "\";\n");
                    ++i;
                    continue;
                }
                out.write("fil[\"" + i + "\"]= \"" + tempPath + "@@@" + tempTitle + "@@@...\";\n");
                ++i;
            }
            out.write("var doStem = " + doStem + ";");
            out.write("searchLoaded = true;");
            out.flush();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void writeIndex(String indexFileName, ScoreRepository sk, String indexerLanguage) {
        if (sk == null || indexFileName == null) {
            return;
        }
        TreeMap<String, String> scores = sk.getScores();
        Iterator<String> wordsIterator = scores.keySet().iterator();
        int indexSize = scores.size();
        File fileOut = new File(indexFileName);
        for (int i = 1; i <= 3; ++i) {
            String fOutName = fileOut.getParent() + File.separator + "index-" + i + fileOut.getName();
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(fOutName)), "UTF-8");){
                int count = 0;
                if (i == 1) {
                    this.writeStopWords(out, sk);
                    out.write("\nvar indexerLanguage=\"" + indexerLanguage + "\";\n");
                }
                out.write("\n// Auto generated index for searching.\n");
                while (wordsIterator.hasNext()) {
                    String tstr = wordsIterator.next();
                    String tstrEscaped = tstr.replace("\\", "\\\\");
                    tstrEscaped = tstrEscaped.replace("\"", "\\\"");
                    String indexEntry = "w[\"" + tstrEscaped + "\"]=" + scores.get(tstr) + "\n";
                    out.write(indexEntry);
                    if (indexSize / ++count >= 3 || i >= 3) continue;
                    break;
                }
                out.write("\n");
                out.flush();
                continue;
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        logger.info("Generated index files are located in " + fileOut.getParent());
    }

    @Override
    public void writeKeywords(String keywordsFileName, IKeywordsRepository keywordsRepository) {
        if (keywordsFileName == null || keywordsRepository == null) {
            return;
        }
        File fileOut = new File(keywordsFileName);
        List<KeywordsRepository.KeywordInfo> keywords = keywordsRepository.getKeywords();
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(fileOut)), "UTF-8");){
            out.append("var keywords=[");
            Iterator<KeywordsRepository.KeywordInfo> iterator = keywords.iterator();
            while (iterator.hasNext()) {
                KeywordsRepository.KeywordInfo kw = iterator.next();
                out.append("{w:\"" + this.escapeJavaScript(kw.word) + "\",p:[");
                Iterator<String> phIdsIter = kw.phraseIDs.iterator();
                while (phIdsIter.hasNext()) {
                    String phID = phIdsIter.next();
                    out.append("\"" + phID + "\"");
                    if (!phIdsIter.hasNext()) continue;
                    out.append(",");
                }
                out.append("]}");
                if (!iterator.hasNext()) continue;
                out.append(",");
            }
            out.append("];");
            out.append("\nvar ph={};\n");
            Map<String, List<Integer>> phraseMap = keywordsRepository.getPhraseMap();
            for (String phID : phraseMap.keySet()) {
                out.append("ph[\"" + phID + "\"]=");
                out.append(phraseMap.get(phID).toString());
                out.append(";\n");
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            logger.error("Cannot write search keywords: " + e.getMessage());
        }
    }

    @Override
    public void writeStopWords(OutputStreamWriter osw, ScoreRepository sk) throws IOException {
        if (sk == null || osw == null) {
            logger.error("Cannot write stopwords, null parameter.");
            return;
        }
        osw.write("// Auto generated list of analyzer stop words that must be ignored by search.\n");
        osw.write("stopWords = new Array();\n");
        ArrayList<String> stopWords = sk.getStopWords();
        int stopWordsCounter = 0;
        for (String nextStopWord : stopWords) {
            osw.write("stopWords[" + stopWordsCounter + "]= \"" + nextStopWord + "\";\n");
            ++stopWordsCounter;
        }
        osw.flush();
    }

    @Override
    public void writeLinkToParent(File file, List<IndexedFileInfo> filesDescription, File parentDirectory) {
    }
}

