/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.indexer;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.StringUtils;
import ro.sync.exml.indexer.OutputType;
import ro.sync.exml.indexer.StopWordsPreferences;
import ro.sync.exml.indexer.js.JsFilesBuilder;
import ro.sync.exml.indexer.js.WebHelpClassicJsFilesBuilder;
import ro.sync.exml.indexer.js.WebHelpResponsiveJsFilesBuilder;
import ro.sync.exml.indexer.keywords.IKeywordsRepository;
import ro.sync.exml.indexer.keywords.KeywordsRepository;
import ro.sync.exml.indexer.parser.SaxDocFileParser;
import ro.sync.exml.indexer.score.ElementScoreProvider;
import ro.sync.exml.indexer.score.IScoreProvider;
import ro.sync.exml.indexer.score.ScoreRepository;
import ro.sync.exml.indexer.utils.IndexedFileInfo;

public class IndexerTask
extends Task {
    private static final String KEYWORDS_JS_NAME = "keywords.js";
    private String txt_cannot_create_outputdir = "Cannot create output search directory.";
    private String txt_no_html_files = "No HTML Files found in";
    private String propsDir = null;
    private String outputDir = null;
    private String indexerLanguage = "en";
    private String htmlExtension = "html";
    private String userDictionary = null;
    private boolean stem;
    private FileSet fileSet;
    private IScoreProvider elementScoreProvider;
    private String doNotIndexElements;
    private String searchIndexElementsToExclude;
    private boolean writeWordIndices = true;
    private IKeywordsRepository keywordsRepository = new KeywordsRepository();
    private OutputType outputType;
    private String stopWordsExclude;
    private String stopWordsInclude;
    private File tempDir;

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public void setTempDir(File tempDir) {
        this.tempDir = tempDir;
    }

    public void setPropsDir(String propsDir) {
        this.propsDir = propsDir;
    }

    public void setStopWordsExclude(String stopWordsExclude) {
        this.stopWordsExclude = stopWordsExclude;
    }

    public void setStopWordsInclude(String stopWordsInclude) {
        this.stopWordsInclude = stopWordsInclude;
    }

    public void setUserDictionary(String userDictionary) {
        this.userDictionary = userDictionary;
        if (this.keywordsRepository != null) {
            this.keywordsRepository.setUserDictionary(userDictionary);
        }
    }

    public void setHtmlExtension(String htmlExtension) {
        this.htmlExtension = htmlExtension;
        if (this.htmlExtension.startsWith(".")) {
            this.htmlExtension = this.htmlExtension.substring(1);
        }
    }

    public void setSearchIndexElementsToExclude(String searchIndexElementsToExclude) {
        this.searchIndexElementsToExclude = searchIndexElementsToExclude;
    }

    public void setIndexerLanguage(String indexerLanguage) {
        int temp;
        if (indexerLanguage == null) {
            indexerLanguage = "";
        }
        if (!"".equals(indexerLanguage) && (temp = indexerLanguage.indexOf(95)) != -1) {
            indexerLanguage = indexerLanguage.substring(0, temp);
        }
        this.indexerLanguage = indexerLanguage.toLowerCase();
        if (this.keywordsRepository != null) {
            this.keywordsRepository.setLanguageCode(this.indexerLanguage);
        }
    }

    public void execute() throws BuildException {
        if (!this.initialized()) {
            return;
        }
        if (StringUtils.trimToNull((String)this.searchIndexElementsToExclude) != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.doNotIndexElements);
            stringBuilder.append(',');
            stringBuilder.append(this.searchIndexElementsToExclude);
            this.doNotIndexElements = stringBuilder.toString();
        }
        this.elementScoreProvider = new ElementScoreProvider(this.propsDir);
        this.elementScoreProvider.addDoNotIndex(this.doNotIndexElements);
        ScoreRepository sr = new ScoreRepository(this.elementScoreProvider);
        sr.setWriteWordIndices(this.writeWordIndices);
        StopWordsPreferences stopWordsPreferences = new StopWordsPreferences(this.stopWordsExclude, this.stopWordsInclude);
        SaxDocFileParser spe = new SaxDocFileParser(sr, this.indexerLanguage, this.userDictionary, this.stem, this.keywordsRepository, stopWordsPreferences);
        spe.setElementsNotToIndex(this.doNotIndexElements);
        ArrayList<String> htmlFilesPathRel = new ArrayList<String>();
        ArrayList<IndexedFileInfo> filesDescription = new ArrayList<IndexedFileInfo>();
        Iterator fsIterator = this.fileSet.iterator();
        if (!fsIterator.hasNext()) {
            System.out.println(this.txt_no_html_files + " " + this.fileSet.getDir() + ".");
            return;
        }
        while (fsIterator.hasNext()) {
            FileResource resource = (FileResource)fsIterator.next();
            String fileRelPath = resource.getName();
            htmlFilesPathRel.add(fileRelPath);
            File htmlFile = resource.getFile();
            System.out.println("Parse HTML file: " + htmlFile);
            IndexedFileInfo docFileInfoTemp = new IndexedFileInfo(spe.parseDocument(htmlFile, fileRelPath));
            filesDescription.add(docFileInfoTemp);
        }
        String htmlInfoListFile = "htmlFileInfoList.js";
        String indexName = ".js";
        JsFilesBuilder jsFilesBuilder = this.outputType == OutputType.WH_RESPONSIVE ? new WebHelpResponsiveJsFilesBuilder() : new WebHelpClassicJsFilesBuilder();
        jsFilesBuilder.writeIndex(this.outputDir.concat(File.separator).concat(indexName), sr, this.indexerLanguage);
        jsFilesBuilder.writeHTMLInfoList(this.outputDir.concat(File.separator).concat(htmlInfoListFile), filesDescription, this.stem);
        String linkToParentFile = "link-to-parent.js";
        jsFilesBuilder.writeLinkToParent(new File(this.outputDir, linkToParentFile), filesDescription, this.tempDir);
        jsFilesBuilder.writeKeywords(this.outputDir.concat(File.separator).concat(KEYWORDS_JS_NAME), this.keywordsRepository);
    }

    private boolean initialized() {
        boolean b;
        File tempfile = new File(this.outputDir);
        if (!tempfile.exists() && !(b = new File(this.outputDir).mkdir())) {
            System.out.println(this.txt_cannot_create_outputdir + " " + this.outputDir + ".");
            return false;
        }
        return true;
    }

    public void setStem(boolean stem) {
        this.stem = stem;
    }

    public void setDoNotIndex(String elements) {
        this.doNotIndexElements = elements;
    }

    public void addConfiguredFileset(FileSet fileSet) {
        this.fileSet = fileSet;
    }

    public void setWriteWordIndices(boolean writeWordIndices) {
        this.writeWordIndices = writeWordIndices;
    }

    public void setEnableAutocomplete(boolean enableAutocomplete) {
        this.keywordsRepository.setEnableRepository(enableAutocomplete);
    }

    public void setOutputType(OutputType type) {
        this.outputType = type;
    }
}

