<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs" version="2.0">
    <xsl:output omit-xml-declaration="yes" indent="yes"/>
    <xsl:param name="rootName">topicmeta</xsl:param>
    <xsl:param name="linktext">linktext</xsl:param>
    <xsl:param name="navtitle">navtitle</xsl:param>

    <xsl:template match="@* | node()">
        <xsl:copy>
            <xsl:apply-templates select="@* | node()"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="*[name() = $navtitle]">
        <xsl:copy>
            <xsl:apply-templates select="@* | node()"/>
        </xsl:copy>
        <xsl:if test="not(following-sibling::*[name() = $linktext])">
            <xsl:call-template name="insertEmptyLinkText"/>
        </xsl:if>
    </xsl:template>

    <xsl:template match="*[name() = $rootName]">
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:if test="count(child::*[name() = $linktext]) = 0">
                <xsl:if test="count(child::*[name() = $navtitle]) = 0">
                    <xsl:call-template name="insertEmptyLinkText"/>
                </xsl:if>
            </xsl:if>
            <xsl:apply-templates select="node()"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template name="insertEmptyLinkText">
        <xsl:element name="{$linktext}">
            <xsl:text>$select("Insert link text here")</xsl:text>
        </xsl:element>
    </xsl:template>

    <xsl:template match="*[name() = $linktext][1]">
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:text>$select("</xsl:text>
            <xsl:if test="not(node())">
                <xsl:text>Insert link text here</xsl:text>
            </xsl:if>
            <xsl:apply-templates select="node()"/>
            <xsl:text>")</xsl:text>
        </xsl:copy>
    </xsl:template>

</xsl:stylesheet>
