<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    exclude-result-prefixes="xs util s"
    xmlns:util="http://www.oxygenxml.com/ns/framework/extend/util"
    xmlns:s="http://www.oxygenxml.com/ns/framework/extend"
    version="3.0">
    
    <xd:doc scope="stylesheet" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Updates author extensions, like CSS, toolbar configurations etc.</xd:p>
        </xd:desc>
    </xd:doc>
    
    <xd:doc scope="stylesheet" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>A copy template to pass the script parameter. I wasn't able to override a tunnel
            parameter once set.</xd:p>
        </xd:desc>
        <xd:param name="tScript">Current toolbar or group update script.</xd:param>
    </xd:doc>
    <xsl:template match="node() | @*" mode="copy-toolbar">
        <xsl:param name="tScript"/>
        <xsl:copy>
            <xsl:apply-templates select="node() | @*" mode="#current">
                <xsl:with-param name="tScript" select="$tScript"/>
            </xsl:apply-templates>
        </xsl:copy>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Updates default toolbar configuration.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template match="authorExtension/field[@name='toolbarDescriptor']/toolbar" mode="copy-target">
        <xsl:call-template name="handleRootToolbar">
            <xsl:with-param name="isDefaultToolbar" select="true()"/>
        </xsl:call-template>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Updates addditional toolbars. Appends all new toolbars to the additional toolbars.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template 
        match="authorExtension/field[@name='additionalToolbarsDescriptors']/toolbar-array" 
        mode="copy-target">
        <xsl:copy>
            <xsl:apply-templates mode="#current"/>
            
            <xsl:call-template name="createAdditionalToolbars"/>
        </xsl:copy>
    </xsl:template>
    
    <xsldoc:doc xmlns:xsldoc="http://www.oxygenxml.com/ns/doc/xsl">
        <xsldoc:desc>No additional toolbars were configured in base.</xsldoc:desc>
    </xsldoc:doc>
    <xsl:template 
        match="authorExtension/field[@name='additionalToolbarsDescriptors']/null" 
        mode="copy-target">
        <toolbar-array>
            <xsl:call-template name="createAdditionalToolbars"/>
        </toolbar-array>
    </xsl:template>
    
    <xsldoc:doc xmlns:xsldoc="http://www.oxygenxml.com/ns/doc/xsl">
        <xsldoc:desc>Add additional toolbars.</xsldoc:desc>
    </xsldoc:doc>
    <xsl:template name="createAdditionalToolbars">
        <!-- Check if there are any new toolbars that should be appended here. -->
        <xsl:variable name="rootToolbar"
            select="../../field[@name = 'toolbarDescriptor']/toolbar/field[@name = 'id']/String/text()"/>
        <xsl:variable name="existingToolbars" select="toolbar/field[@name = 'id']/String/text()"/>

        <xsl:variable name="allToolbars" select="($rootToolbar, $existingToolbars)"/>

        <xsl:variable name="toolbarUpdateScripts"
            select="$script/s:author/s:toolbars/s:toolbar[@name and empty(index-of($allToolbars, @name))]"/>
        <xsl:for-each select="$toolbarUpdateScripts">
            <xsl:sequence select="util:createMainToolbar(.)"/>
        </xsl:for-each>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Updates additional toolbars.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template 
        match="authorExtension/field[@name='additionalToolbarsDescriptors']/toolbar-array/toolbar" 
        mode="copy-target">
        <xsl:call-template name="handleRootToolbar"/>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Updates a root toolbar, the actual toolbars. Groups withing a tollbar are serialized
            as toolbars. This template is called when the context element is a root template, not a group.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template name="handleRootToolbar">
        <xsl:param name="isDefaultToolbar" select="false()"/>
        <xsl:variable name="tName" select="field[@name='id']/String/text()"/>
        <xsl:variable name="toolbarUpdateScript" 
            select="$script/s:author/s:toolbars/s:toolbar[@name=$tName or (string-length(@name) = 0 and $isDefaultToolbar)]"/>
        <xsl:choose>
            <xsl:when test="$toolbarUpdateScript
                or $script/s:author/s:authorActions/s:removeAction">
                <!-- We have a configuration script for this toolbar. -->
                <xsl:variable name="generatedToolbar">
                    <xsl:copy>
                        <xsl:apply-templates select="node() | @*" mode="copy-toolbar">
                            <xsl:with-param name="tScript" select="$toolbarUpdateScript" />
                        </xsl:apply-templates>
                    </xsl:copy>
                </xsl:variable>
                
                <xsl:apply-templates select="$generatedToolbar" mode="normalize-separators"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy>
                    <xsl:apply-templates select="node() | @*" mode="#current"/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Toolbar items.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template match="toolbarEntry-array/toolbarSeparator" mode="normalize-separators">
        <xsl:if test="empty(preceding-sibling::*[1][self::toolbarSeparator])">
            <xsl:next-match/>
        </xsl:if>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Toolbar items.</xd:p>
        </xd:desc>
        <xd:param name="tScript">Current toolbar or group update script.</xd:param>
    </xd:doc>
    <xsl:template match="toolbarEntry-array" mode="copy-toolbar">
        <xsl:param name="tScript"/>
        
        <xsl:variable name="toolbarEntryArray" select="."/>
        <xsl:copy>
            <!-- Copy any entries without an anchor. -->
            <xsl:variable name="beforeItems" 
                select="$tScript/(
                s:addAction, 
                s:separator, 
                s:group[not(util:isPresentInBaseToolbars($toolbarEntryArray, @name))]
                )[not(@anchor)][@position = 'before']"/>
            <xsl:for-each select="$beforeItems" >
                <xsl:sequence select="util:createToolbarEntry(.)"/>
            </xsl:for-each>
            
            <xsl:apply-templates select="@* | node()" mode="#current">
                <xsl:with-param name="tScript" select="$tScript"/>
            </xsl:apply-templates>
            
            <!-- Copy any entries without an anchor. -->
            <xsl:variable name="beforeItems" 
                select="$tScript/
                (
                s:addAction, 
                s:separator, 
                s:group[not(util:isPresentInBaseToolbars($toolbarEntryArray, @name))]
                )[not(@anchor)][not(@position) or @position = 'after']"/>
            <xsl:for-each select="$beforeItems" >
                <xsl:sequence select="util:createToolbarEntry(.)"/>
            </xsl:for-each>
            
        </xsl:copy>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Toolbar items.</xd:p>
        </xd:desc>
        <xd:param name="tScript">Current toolbar or group update script.</xd:param>
    </xd:doc>
    <xsl:template match="toolbarEntry-array/*" mode="copy-toolbar">
        <xsl:param name="tScript"/>
        <xsl:param name="skippedAuthorActions" tunnel="yes"/>
        
        <xsl:variable name="toolbarEntryArray" select="parent::*"/>
        <xsl:variable name="toolbarItemId" select="field[@name='actionID' or @name='id']/String/text()"/>
        
        <!-- Step 1. Write all actions that come BEFORE this particular entry. -->
        <xsl:variable name="beforeItems" select="$tScript/
            (s:addAction, s:separator, s:group[not(util:isPresentInBaseToolbars($toolbarEntryArray, @name))])
            [@anchor = $toolbarItemId][@position='before']"/>
        <xsl:for-each select="$beforeItems" >
            <xsl:sequence select="util:createToolbarEntry(.)"/>
        </xsl:for-each>
        
        <!-- Step 2.  Write this action, if not removed -->
        <xsl:if test="
            not($tScript/(s:removeAction[@id = $toolbarItemId], s:removeGroup[@name = $toolbarItemId]))
            and (empty($toolbarItemId) or empty(index-of($skippedAuthorActions, $toolbarItemId)))">
            <!-- Identify the update script that refers to the group we are about to enter. -->
        <xsl:variable name="nextScript" 
            select="if (self::toolbar) then ($tScript/s:group[@name=$toolbarItemId]) else ()"/>
            <xsl:copy>
                <xsl:apply-templates select="node() | @*" mode="#current">
                    <xsl:with-param name="tScript" select="$nextScript"/>
                </xsl:apply-templates>
            </xsl:copy>
        </xsl:if>
        
        <!-- Step 3. Write all actions that come AFTER this particular entry. -->
        <xsl:variable name="afterItems" select="$tScript/
            (s:addAction, s:separator, s:group[not(util:isPresentInBaseToolbars($toolbarEntryArray, @name))])
            [@anchor = $toolbarItemId][not(@position) or @position='after']"/>
        <xsl:for-each select="$afterItems" >
            <xsl:sequence select="util:createToolbarEntry(.)"/>
        </xsl:for-each>
    </xsl:template>
    
    
    <xsl:template match="toolbar/field[@name='largeIconPath']/String" mode="copy-toolbar">
        <xsl:param name="tScript"/>
        
        <xsl:choose>
            <xsl:when test="$tScript/@largeIconPath">
                <xsl:copy>
                    <xsl:value-of select="$tScript/@largeIconPath"/>
                </xsl:copy>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy-of select="."/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="toolbar/field[@name='smallIconPath']/String" mode="copy-toolbar">
        <xsl:param name="tScript"/>
        
        <xsl:choose>
            <xsl:when test="$tScript/@smallIconPath">
                <xsl:copy>
                    <xsl:value-of select="$tScript/@smallIconPath"/>
                </xsl:copy>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy-of select="."/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>