<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    exclude-result-prefixes="xs util s"
    xmlns:util="http://www.oxygenxml.com/ns/framework/extend/util"
    xmlns:s="http://www.oxygenxml.com/ns/framework/extend"
    version="3.0">
    
    <xd:doc scope="stylesheet" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Updates author extensions, like CSS, toolbar configurations etc.</xd:p>
        </xd:desc>
    </xd:doc>
    
    <xd:doc scope="stylesheet" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>A copy template to pass the script parameter. I wasn't able to override a tunnel
            parameter once set.</xd:p>
        </xd:desc>
        <xd:param name="tScript">Current menu update script.</xd:param>
    </xd:doc>
    <xsl:template match="node() | @*" mode="copy-menu">
        <xsl:param name="tScript"/>
        <xsl:copy>
            <xsl:apply-templates select="node() | @*" mode="#current">
                <xsl:with-param name="tScript" select="$tScript"/>
            </xsl:apply-templates>
        </xsl:copy>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Updates default contextual menu configuration.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template
        match="authorExtension/field[@name='popupMenuDescriptor']/menu"
        mode="copy-target">
        <xsl:call-template name="handleRootMenu">
            <xsl:with-param name="menuUpdateScript" select="$script/s:author/s:contextualMenu"/>
        </xsl:call-template>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Updates default menu configuration.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template
        match="authorExtension/field[@name='menubarDescriptor']/menu"
        mode="copy-target">
        <xsl:call-template name="handleRootMenu">
            <xsl:with-param name="menuUpdateScript" select="$script/s:author/s:menu"/>
        </xsl:call-template>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Overrides the main menu label, if the configuration script contains a new name.</xd:p>
        </xd:desc>
        <xd:param name="tScript">Current menu or submenu update script.</xd:param>
    </xd:doc>
    <xsl:template
        match="authorExtension/field[@name='menubarDescriptor']/menu/field[@name='label']"
        mode="copy-menu">
        <xsl:param name="tScript"/>
        
        <xsl:copy>
            <xsl:apply-templates select="@*" mode="#current"/>
            <xsl:choose>
                <xsl:when test="$tScript and $tScript/@name and string-length($tScript/@name) > 0">
                    <xsl:sequence select="util:stringValue($tScript/@name)"></xsl:sequence>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="node()" mode="#current"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:copy>
    </xsl:template>
    
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Updates a root menu. </xd:p>
        </xd:desc>
        <xd:param name="menuUpdateScript">The part from the script that describes how to change the menu.</xd:param>
    </xd:doc>
    <xsl:template name="handleRootMenu">
        <xsl:param name="menuUpdateScript"/>
        
        <xsl:choose>
            <xsl:when test="$menuUpdateScript 
                or $script/s:author/s:authorActions/s:removeAction">
                <!-- We have a configuration script for this toolbar. -->
                <xsl:variable name="generatedMenu">
                    <xsl:copy>
                        <xsl:apply-templates select="node() | @*" mode="copy-menu">
                            <xsl:with-param name="tScript" select="$menuUpdateScript" />
                        </xsl:apply-templates>
                    </xsl:copy>
                </xsl:variable>
                
                <xsl:apply-templates select="$generatedMenu" mode="normalize-separators"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy>
                    <xsl:apply-templates select="node() | @*" mode="#current"/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Toolbar items.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template match="menuEntry-array/menuSeparator" mode="normalize-separators">
        <xsl:if test="empty(preceding-sibling::*[1][self::menuSeparator])">
            <xsl:next-match/>
        </xsl:if>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Menu items.</xd:p>
        </xd:desc>
        <xd:param name="tScript">Current menu or submenu update script.</xd:param>
    </xd:doc>
    <xsl:template match="menuEntry-array" mode="copy-menu">
        <xsl:param name="tScript"/>
        
        <xsl:variable name="menuEntryArray" select="."/>
        <xsl:copy>
            <!-- Copy any entries without an anchor. -->
            <xsl:variable name="itemWithoutAnchor" 
                select="$tScript/
                (
                s:addAction, 
                s:separator, 
                s:submenu[not(util:isPresentInBaseMenus($menuEntryArray, @name))]
                )[not(@anchor)][@position = 'before']"/>
            <xsl:for-each select="$itemWithoutAnchor" >
                <xsl:sequence select="util:createMenuEntry(.)"/>
            </xsl:for-each>
            
            <xsl:apply-templates select="@* | node()" mode="#current">
                <xsl:with-param name="tScript" select="$tScript"/>
            </xsl:apply-templates>
            
            <!-- Copy any entries without an anchor. -->
            <xsl:variable name="itemWithoutAnchor" 
                select="$tScript/
                (
                s:addAction, 
                s:separator, 
                s:submenu[not(util:isPresentInBaseMenus($menuEntryArray, @name))]
                )[not(@anchor)][not(@position) or @position = 'after']"/>
            <xsl:for-each select="$itemWithoutAnchor" >
                <xsl:sequence select="util:createMenuEntry(.)"/>
            </xsl:for-each>
            
        </xsl:copy>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Toolbar items.</xd:p>
        </xd:desc>
        <xd:param name="tScript">Current toolbar or group update script.</xd:param>
    </xd:doc>
    <xsl:template match="menuEntry-array/*" mode="copy-menu">
        <xsl:param name="tScript"/>
        <xsl:param name="skippedAuthorActions" tunnel="yes"/>
        
        <xsl:variable name="itemId" select="field[@name='actionID' or @name='label']/String/text()"/>
        <xsl:variable name="menuEntryArray" select="parent::*"/>
        
        <!-- Step 1. Write all actions that come BEFORE this particular entry. -->
        <xsl:variable name="beforeItems" select="$tScript/
            (s:addAction, s:separator, s:submenu[not(util:isPresentInBaseMenus($menuEntryArray, @name))])
            [@anchor = $itemId][@position='before']"/>
        <xsl:for-each select="$beforeItems" >
            <xsl:sequence select="util:createMenuEntry(.)"/>
        </xsl:for-each>
        
        <!-- Step 2.  Write this action, if not removed -->
        <xsl:if test="
            not($tScript/(s:removeAction[@id = $itemId], s:removeSubmenu[@name = $itemId]))
            and (empty($itemId) or empty(index-of($skippedAuthorActions, $itemId)))">
            <!-- Identify the update script that refers to the group we are about to enter. -->
            <xsl:variable name="nextScript" select="$tScript/s:submenu[@name=$itemId]"/>
            <xsl:copy>
                <xsl:apply-templates select="node() | @*" mode="#current">
                    <xsl:with-param name="tScript" select="$nextScript"/>
                </xsl:apply-templates>
            </xsl:copy>
        </xsl:if>
        
        <!-- Step 3. Write all actions that come AFTER this particular entry. -->
        <xsl:variable name="afterItems" select="$tScript/
            (s:addAction, s:separator, s:submenu[not(util:isPresentInBaseMenus($menuEntryArray, @name))])
            [@anchor = $itemId][not(@position) or @position='after']"/>
        <xsl:for-each select="$afterItems" >
            <xsl:sequence select="util:createMenuEntry(.)"/>
        </xsl:for-each>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Updates menu icons.</xd:p>
        </xd:desc>
        <xd:param name="tScript">Current menu update script.</xd:param>
    </xd:doc>
    <xsl:template match="menu/field[@name='iconPath']/String" mode="copy-menu">
        <xsl:param name="tScript"/>
        
        <xsl:choose>
            <xsl:when test="$tScript/@iconPath">
                <xsl:copy>
                    <xsl:value-of select="$tScript/@iconPath"/>
                </xsl:copy>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy-of select="."/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    
</xsl:stylesheet>