/*
 * Copyright (c) 2018 Syncro Soft SRL - All Rights Reserved.
 *
 * This file contains proprietary and confidential source code.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */
package org.w3c.flute.parser.selectors.spc;

import java.util.Map;

/**
 * The :empty pseudo-class represents an element that has 
 * no children at all. In terms of the document tree, only 
 * element nodes and content nodes (such as DOM [DOM-LEVEL-3-CORE] 
 * text nodes, CDATA nodes, and entity references) whose data 
 * has a non-zero length must be considered as affecting emptiness; 
 * comments, processing instructions, and other nodes must not 
 * affect whether an element is considered empty or not. 
 * 
 * @author dan
 *
 * @see "http://www.w3.org/TR/css3-selectors/#empty-pseudo"
 */
public class EmptySPCCondition extends SPCCondition {

  /**
   * @see org.w3c.flute.parser.selectors.spc.SPCCondition#getType()
   */
  @Override
  public Type getType() {
    return Type.EMPTY;
  }
  

  /**
   * @see org.w3c.flute.css.sac.Condition#getSerialization(java.util.Map)
   */
  @Override
  public String getSerialization(Map<String, String> proxyNamespaceMapping) {
    return ":empty";
  }

}
