package org.w3c.flute.parser.selectors;

import java.util.ArrayList;
import java.util.List;

import org.w3c.flute.css.sac.PageSelector;

/**
 * Implements a page selector.
 */
public class PageSelectorImpl implements PageSelector {

  /**
   * Stores zero or more pseudo pages, like the ones defined in the {@link PageSelector}. 
   */
  private List<String> pseudos = null;
  
  /**
   * The name of the page. Can be <code>null</code>.
   */
  private String name;
  
  @Override
  public void addPseudo(String pseudo) {
    if (pseudos == null) {
      pseudos = new ArrayList<String>(1);
    }
    
    // Some kind of intern.
    if (PageSelector.FIRST.equals(pseudo)) {
      pseudo = PageSelector.FIRST;
    } else if (PageSelector.LAST.equals(pseudo)) {
      pseudo = PageSelector.LAST;
    } else if (PageSelector.LEFT.equals(pseudo)) {
      pseudo = PageSelector.LEFT;
    } else if (PageSelector.RIGHT.equals(pseudo)) {
      pseudo = PageSelector.RIGHT;
    } else if (PageSelector.BLANK.equals(pseudo)) {
      pseudo = PageSelector.BLANK;
    } else {
      // Unknown.
      pseudo = null;
    }
    if (pseudo != null) {
      pseudos.add(pseudo);
    }
  }

  @Override
  public void setName(String name) {
    this.name = name;   
  }

  @Override
  public Iterable<String> getPseudos() {
    return pseudos;
  }

  @Override
  public String getName() {    
    return name;
  }

  @Override
  public boolean containsPseudo(String pseudo) {
    boolean contains = false;
    if (pseudos != null) {
       contains = pseudos.contains(pseudo);
    }
    return contains;
  }

  
  /**
   * Formats a string with the page selector, similar 
   * to the one from the CSS source. 
   *
   * @see java.lang.Object#toString()
   */
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    
    if (name != null) {
      sb.append(name);
    }
    
    if (pseudos != null) {
      int size = pseudos.size();
      for (int i = 0; i < size; i++) {
        sb.append(":");
        sb.append(pseudos.get(i));
        if ( i < size - 1) {
          sb.append(" ");
        }
      } 
    }
    return sb.toString();
  }

}
