/*
 * Copyright (c) 2018 Syncro Soft SRL - All Rights Reserved.
 *
 * This file contains proprietary and confidential source code.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */
package org.w3c.flute.parser.selectors;

import java.util.Map;

import org.w3c.flute.css.sac.Condition;
import org.w3c.flute.css.sac.NegativeCondition;
import org.w3c.flute.css.sac.Selector;

/**
 * The condition matches the current element when the negation of the selector is <code>true</code>.
 * 
 * @author dan
 */
public class NegativeConditionImpl implements NegativeCondition {
  
  /**
   * The negation selector.
   */
  private Selector selector;

  /**
   * Builds a negative condition.
   * 
   * @param selector The selector that is evaluated by the condition. If the selector
   * is not matched, the condition is accomplished.
   */
  public NegativeConditionImpl(Selector selector) {
    this.selector = selector;
  }

  /**
   * @see org.w3c.css.sac.Condition#getConditionType()
   */
  @Override
  public short getConditionType() {
    return Condition.SAC_NEGATIVE_CONDITION;
  }


  /**
   * Gets the selector to be negated.
   * 
   * @return the selector, never <code>null</code>.
   */
  @Override
  public Selector getSelector() {
    return selector;    
  }

  /**
   * @see org.w3c.flute.css.sac.Condition#getSerialization(Map)
   */
  @Override
  public String getSerialization(Map<String, String> proxyNamespaceMapping) {   
    return ":not(" + selector.getSerialization(proxyNamespaceMapping) + ")";
  }
}
