/*
 * Copyright (c) 2018 Syncro Soft SRL - All Rights Reserved.
 *
 * This file contains proprietary and confidential source code.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */
package org.w3c.flute.parser;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

/**
 * List of media queries
 */
public class MediaQueryList implements Iterable<MediaQuery>, Cloneable {

  /**
   * The set of queries.
   */
  private final Set<MediaQuery> listOfMediaQueries;

  /**
   * Constructor.
   */
  public MediaQueryList() {
    listOfMediaQueries = new LinkedHashSet<MediaQuery>();
  }

  /**
   * Add a media query.
   * @param mediaQuery The media query to add.
   */
  public void addMediaQuery(MediaQuery mediaQuery) {
    listOfMediaQueries.add(mediaQuery);
  }

  /**
   * Add all queries from the list.
   * @param otherList The other list.
   */
  public void addAllMediaQueries(MediaQueryList otherList) {
    for (MediaQuery atomicMedia : otherList) {
      addMediaQuery(atomicMedia);
    }
  }
  
  /**
   * Remove media query.
   * @param media The media query.
   */
  public void removeMediaQuery(MediaQuery media) {
    listOfMediaQueries.remove(media);
  }
  
  /**
   * Remove all media queries.
   * @param mediaQueryList The queries list.
   */
  public void removeAllMediaQueries(MediaQueryList mediaQueryList) {
    for (MediaQuery mediaQuery : mediaQueryList)
      listOfMediaQueries.remove(mediaQuery);
  }
  
  /**
   * Get the number of media queries.
   * 
   * @return the number of media queries. 
   */
  public int size() {
    return listOfMediaQueries.size();
  }


  /**
   * @see java.lang.Iterable#iterator()
   */
  @Override
  public Iterator<MediaQuery> iterator() {
    return listOfMediaQueries.iterator();
  }

  /**
   * @see java.lang.Object#hashCode()
   */
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime
        * result
        + ((listOfMediaQueries == null) ? 0 : listOfMediaQueries
            .hashCode());
    return result;
  }

  /**
   * @see java.lang.Object#equals(java.lang.Object)
   */
  @Override
  public boolean equals(Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    MediaQueryList other = (MediaQueryList) obj;
    if (listOfMediaQueries == null) {
      if (other.listOfMediaQueries != null)
        return false;
    } else if (!listOfMediaQueries.equals(other.listOfMediaQueries))
      return false;
    return true;
  }

  /**
   * @see java.lang.Object#toString()
   */
  @Override
  public String toString() {
    StringBuilder toReturn = new StringBuilder("@media ");
    for (Iterator<MediaQuery> iterator = listOfMediaQueries.iterator(); iterator.hasNext();) {
      MediaQuery query = iterator.next();
      toReturn.append(query);
      if (iterator.hasNext())
        toReturn.append(", ");
    }
    
    return toReturn.toString();
  }
  
  /**
   * @see java.lang.Object#clone()
   */
  public MediaQueryList clone() {
    MediaQueryList newOne = new MediaQueryList();
    for (MediaQuery query : listOfMediaQueries) {
      newOne.addMediaQuery(query);
    }
    return newOne;
  }
}