/*
 * (c) COPYRIGHT 1999 World Wide Web Consortium
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 *
 * $Id: SiblingSelector.java,v 1.3 2000/07/27 21:19:21 plehegar Exp $
 */
package org.w3c.flute.css.sac;


/**
 * @version $Revision: 1.3 $
 * @author  Philippe Le Hegaret
 * @see Selector#SAC_DIRECT_ADJACENT_SELECTOR
 */
public interface SiblingSelector extends Selector {

    /**
     * Constant defining the any node type.
     * 
     * @see #getNodeType()
     */
    static final short ANY_NODE = 201;

    /**
     * The node type to considered in the siblings list.
     * All DOM node types are supported. In order to support the "any" node
     * type, the code ANY_NODE is added to the DOM node types.
     * 
     * @return The type of node.
     */
    short getNodeType();
    
    /**
     * Returns the first selector. This is the selector that is before the adjacency operator. In A + B, is A.
     * 
     * @return The selector that should match one of the previous siblings of the current element.
     */    
    Selector getSelector();

    /**
     * The selector that is after the adjacency operator. In A + B, is B.
     * 
     * @return the selector that matches the current element.
     */
    SimpleSelector getSiblingSelector();
}
