<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:a="http://relaxng.org/ns/compatibility/annotations/1.0"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:html="http://www.w3.org/1999/xhtml"

                xmlns:rng="http://relaxng.org/ns/structure/1.0"
                xmlns:tei="http://www.tei-c.org/ns/1.0"
                xmlns:teix="http://www.tei-c.org/ns/Examples"
                
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                exclude-result-prefixes="a fo rng tei teix"
                version="3.0">
  <doc xmlns="http://www.oxygenxml.com/ns/doc/xsl" scope="stylesheet" type="stylesheet">
      <desc>
         <p> TEI stylesheet dealing with elements from the corpus module,
      making HTML output. </p>
         <p>This software is dual-licensed:

1. Distributed under a Creative Commons Attribution-ShareAlike 3.0
Unported License http://creativecommons.org/licenses/by-sa/3.0/ 

2. http://www.opensource.org/licenses/BSD-2-Clause
		


Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

* Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

This software is provided by the copyright holders and contributors
"as is" and any express or implied warranties, including, but not
limited to, the implied warranties of merchantability and fitness for
a particular purpose are disclaimed. In no event shall the copyright
holder or contributors be liable for any direct, indirect, incidental,
special, exemplary, or consequential damages (including, but not
limited to, procurement of substitute goods or services; loss of use,
data, or profits; or business interruption) however caused and on any
theory of liability, whether in contract, strict liability, or tort
(including negligence or otherwise) arising in any way out of the use
of this software, even if advised of the possibility of such damage.
</p>
         <p>Author: See AUTHORS</p>
         
         <p>Copyright: 2013, TEI Consortium</p>
      </desc>
   </doc>
  <doc xmlns="http://www.oxygenxml.com/ns/doc/xsl">
      <desc>Process element teiCorpus</desc>
   </doc>

  <xsl:template match="tei:teiCorpus">
    <html>
      <xsl:call-template name="addLangAtt"/>
      <head>
	<title>
	  <xsl:apply-templates select="tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title/text()"/>
	</title>
	<xsl:call-template name="includeCSS"/>
        <xsl:call-template name="javascriptHook"/>
	<xsl:call-template name="cssHook"/>
      </head>
      <body class="simple">
	<xsl:call-template name="bodyMicroData"/>
	<xsl:call-template name="bodyHook"/>
	<xsl:call-template name="bodyJavascriptHook"/>
	<div class="stdheader  autogenerated">
	  <xsl:call-template name="stdheader">
	    <xsl:with-param name="title">
	      <xsl:apply-templates select="tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title"/>
	    </xsl:with-param>
	  </xsl:call-template>
	</div>
	<xsl:apply-templates/>
	<xsl:call-template name="stdfooter"/>
	<xsl:call-template name="bodyEndHook"/>
      </body>
      <xsl:call-template name="teiEndHook"/>
    </html>

  </xsl:template>
  
  <xsl:template match="tei:teiCorpus" mode="split">
      <xsl:variable name="BaseFile">
         <xsl:value-of select="$masterFile"/>
         <xsl:call-template name="addCorpusID"/>
      </xsl:variable>
      <xsl:if test="$verbose='true'">
         <xsl:message>TEI HTML: run start hook template teiStartHook</xsl:message>
      </xsl:if>
      <xsl:call-template name="teiStartHook"/>
      <xsl:if test="$verbose='true'">
         <xsl:message>TEI HTML in corpus splitting mode, base file is <xsl:value-of select="$BaseFile"/>
         </xsl:message>
      </xsl:if>
      <xsl:variable name="outName">
         <xsl:call-template name="outputChunkName">
	           <xsl:with-param name="ident">
	              <xsl:value-of select="$BaseFile"/>
	           </xsl:with-param>
         </xsl:call-template>
      </xsl:variable>
    
      <xsl:if test="$verbose='true'">
         <xsl:message>Opening file <xsl:value-of select="$outName"/>
         </xsl:message>
      </xsl:if>
     <xsl:result-document 
              encoding="{$outputEncoding}"
              html-version="{$htmlVersion}"
              normalization-form="{$normalizationForm}"
              href="{$outName}"
              method="{$outputMethod}"
              omit-xml-declaration="{$omitXMLDeclaration}">
              
      <html>
	   <xsl:call-template name="addLangAtt"/>
	   <head>
	     <title>
	       <xsl:apply-templates select="tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title/text()"/>
	     </title>
	     <xsl:call-template name="includeCSS"/>
	     <xsl:call-template name="cssHook"/>
	   </head>
	   <body class="simple">
	     <xsl:call-template name="bodyMicroData"/>
	     <xsl:call-template name="bodyJavascriptHook"/>
	     <xsl:call-template name="bodyHook"/>
	     <div class="stdheader autogenerated">
	       <xsl:call-template name="stdheader">
		 <xsl:with-param name="title">
		   <xsl:apply-templates select="tei:teiHeader/tei:fileDesc/tei:titleStmt/tei:title[1]"/>
		 </xsl:with-param>
	       </xsl:call-template>
	     </div>
	     <xsl:call-template name="corpusBody"/>
	     <xsl:call-template name="stdfooter"/>
	     <xsl:call-template name="bodyEndHook"/>
	   </body>
      </html>
     </xsl:result-document>
      <xsl:if test="$verbose='true'">
         <xsl:message>Closing file <xsl:value-of select="$outName"/>
         </xsl:message>
      </xsl:if>
      <xsl:if test="$verbose='true'">
         <xsl:message>TEI HTML: run end hook template teiEndHook</xsl:message>
      </xsl:if>
      <xsl:call-template name="teiEndHook"/>
      <xsl:apply-templates select="tei:TEI" mode="split"/>                
  </xsl:template>

  <xsl:template name="corpusBody">
    <xsl:call-template name="mainTOC"/>
  </xsl:template>

</xsl:stylesheet>
