<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    exclude-result-prefixes="xs"
    version="3.0"
    xmlns:f="http://www,oxygenxml.com/ns/xslt/functions">
    
    <xsl:key name="element" match="element/@name" use="."/>
    
    <xsl:output method="text"/>
    
    <xsl:variable name="actionsLayerDelete">300</xsl:variable>
    <xsl:variable name="actionsLayerSeparator1">301</xsl:variable>
    <xsl:variable name="actionsLayerSeparator2">401</xsl:variable>
    <xsl:variable name="actionsLayerSeparator3">410</xsl:variable>
    <xsl:variable name="actionsLayer0">405</xsl:variable>
    <xsl:variable name="actionsLayerChildBase">310</xsl:variable>
    <xsl:variable name="actionsLayerBase">409</xsl:variable>    <!-- +2 -->  
    
    <xsl:variable name="borderColor">rgba(200, 200, 200, 0.20)</xsl:variable>
    <xsl:variable name="actionsColor">#105B63</xsl:variable>
    <xsl:variable name="actionsBgNormal">rgba(255, 250, 213, 0.20); /*#FFFAD5*/</xsl:variable>
    <xsl:variable name="actionsBgImportant">rgba(255, 211, 78, 0.20);  /*#FFD34E*/</xsl:variable>
    
    <xsl:variable name="actionsBlock">
        <xsl:text expand-text="yes">
        border:1px solid {$borderColor};
        background-color: {$actionsBgNormal};
        font-weight:normal;
        margin-right:5px;
        display:inline-block;
        font-family:arial, helvetica, sans-serif;
        font-size:10px;
        margin-top:5px;
        </xsl:text>
    </xsl:variable>
    
    <xsl:variable name="required">background-color:#FFD4A0;</xsl:variable>


    <xsl:template match="/">
        <xsl:variable name="processed">
            <processedActions>
                <rules>
                    <xsl:apply-templates mode="actions"/>
                </rules>
            </processedActions>
        </xsl:variable>
        <xsl:call-template name="header2"/>
        <xsl:apply-templates mode="actions2" select="$processed"/>
        <xsl:apply-templates mode="separators2" select="$processed"/>
        <xsl:apply-templates mode="placeholders2"/>
        <xsl:apply-templates mode="deleteAction2"/>
    </xsl:template>
    
    <xsl:template name="header2">
        <xsl:text expand-text="yes">            
/*
 * File generated from 
 * {tokenize(document-uri(.), '/')[last()]}
 * DO NOT EDIT THIS FILE DIRECTLY 
 */
        </xsl:text>
     </xsl:template>
    
    <!-- insert actions -->
    <xsl:template match="emptyParent" mode="actions2">
        <xsl:variable name="action"><xsl:apply-templates mode="insert"/></xsl:variable>
        <xsl:text expand-text="yes">
@media oxygen {{
/* empty {@parent} / {@level} */
{@parent}:empty:after({$actionsLayerChildBase + @level}) {{
    {$actionsBlock}
    content:
        {$action}
    ;
    {if (*/@occurs=('1', '+')) then $required else ''}
}}}}
        </xsl:text>
        <xsl:text>&#10;</xsl:text>
    </xsl:template>
    <xsl:template match="parent-lastChild" mode="actions2">
         <xsl:variable name="action"><xsl:apply-templates mode="insertAfter"/></xsl:variable>
         <xsl:text expand-text="yes">
@media oxygen {{             
{@parent} > {@child}:last-child:after({$actionsLayerBase + 2 * @level}) {{
    {$actionsBlock}
    content:
        {$action}
    ;
    {if (*/@occurs=('1', '+')) then $required else ''}    
}}}}
         </xsl:text>
     </xsl:template> 
    <xsl:template match="parent-firstChild" mode="actions2">
         <xsl:variable name="action"><xsl:apply-templates mode="insertBefore"/></xsl:variable>
         <xsl:text expand-text="yes">
@media oxygen {{             
{@parent} > {@child}:first-child:before({$actionsLayerBase + 2 * @level}) {{
    {$actionsBlock}
    content: 
        {$action}
    ;
    {if (*/@occurs=('1', '+')) then $required else ''}
}}}}
         </xsl:text>
     </xsl:template> 
    <xsl:template match="parent-child-repeat" mode="actions2">
         <xsl:variable name="actionBefore"><xsl:apply-templates mode="insertBefore"/></xsl:variable>
         <xsl:variable name="actionAfter"><xsl:apply-templates mode="insertAfter"/></xsl:variable>
         <xsl:text expand-text="yes">
@media oxygen and (platform:standalone), oxygen and (platform:eclipse) {{             
    {@parent} > {@child}:first-of-type:before({$actionsLayerBase + 2 * @level}) {{
        {$actionsBlock}
        content:
            {$actionBefore}
        ;
    }}
}}
@media oxygen {{
{@parent} > {@child}:after({$actionsLayerBase + 2 * @level}) {{
    {$actionsBlock}
    content:
        {$actionAfter}
    ;
}}}}
         </xsl:text>
     </xsl:template> 
    <xsl:template match="parent-child-reference" mode="actions2">
         <xsl:variable name="action"><xsl:apply-templates mode="insertBefore"/></xsl:variable>
         <xsl:text expand-text="yes">
@media oxygen {{             
{@parent} > {@preceding} + {@reference}:before({$actionsLayerBase + 2 * @level}) {{
    {$actionsBlock}
    content:
        {$action}
    ;
    {if (*/@occurs=('1', '+')) then $required else ''}
}}}}
         </xsl:text>
     </xsl:template>
    <xsl:template match="text()" mode="actions2"/>
    
    <!-- Separators... -->
    
    <xsl:template match="emptyParent[@level='1']" mode="separators2">
        <xsl:text expand-text="yes">
@media oxygen {{            
{@parent}:empty:after({$actionsLayerSeparator1}) {{content: "\A";}}
}}
        </xsl:text>
    </xsl:template>
    <xsl:template match="parent-lastChild[@level='1']" mode="separators2">
         <xsl:text expand-text="yes">
@media oxygen {{
{@parent} > {@child}:last-child:after({$actionsLayerSeparator3}) {{content: "\A";}}
}}
        </xsl:text>         
    </xsl:template>
    <xsl:template match="parent-firstChild[@level='1']" mode="separators2">
         <xsl:text expand-text="yes">
@media oxygen {{             
{@parent} > {@child}:first-child:before({$actionsLayerSeparator3}) {{content: "\A";}}
}}
        </xsl:text>         
    </xsl:template>
    <xsl:template match="parent-child-repeat" mode="separators2">
         <xsl:text expand-text="yes">
@media oxygen and (platform:standalone), oxygen and (platform:eclipse) {{
    {@parent} > {@child}:first-of-type:before({$actionsLayerSeparator2}) {{content: "\A";}}
}}
@media oxygen {{
{@parent} > {@child}:after({$actionsLayerSeparator2}) {{content: "\A";}}
}}
         </xsl:text>
    </xsl:template>
     
    <xsl:template match="parent-child-reference" mode="separators2">
        <xsl:text expand-text="yes">
@media oxygen {{
{@parent} > {@preceding} + {@reference}:before({$actionsLayerSeparator3}) {{content: "\A";}}
}}
        </xsl:text>
    </xsl:template> 
    <xsl:template match="text()" mode="separators2"/>
    
    <!-- buttons -->
    <xsl:template match="choice" mode="insert insertAfter insertBefore">
         <xsl:for-each select="*">
             <xsl:apply-templates mode="#current" select="."/>
             <xsl:if test="position() != last()">
                 <xsl:text xml:space="preserve">
    oxy_label(text, " or ", color, #B08A5D, styles, 'text-decoration:none;')
                 </xsl:text>
             </xsl:if>
         </xsl:for-each>
     </xsl:template>
    <xsl:template match="element" mode="insert">
        <xsl:call-template name="button"/>
    </xsl:template> 
    <xsl:template match="element" mode="insertAfter">
         <xsl:call-template name="button">
             <xsl:with-param name="insertPosition">arg-insertPosition, 'After',</xsl:with-param>
         </xsl:call-template>
    </xsl:template>
    <xsl:template match="element" mode="insertBefore">
         <xsl:call-template name="button">
             <xsl:with-param name="insertPosition">arg-insertPosition, 'Before',</xsl:with-param>
         </xsl:call-template>
    </xsl:template>
    <xsl:template name="button">
        <!-- context item: element -->
        <xsl:param name="insertPosition"/>
        <xsl:text xml:space="preserve" expand-text="yes">
    oxy_button(  
        color, #B08A5D,
        action,
        oxy_action(
            name, '[{f:getLongName(.)}]', 
            description, '{f:getDescription(.)}', 
            operation, 'ro.sync.ecss.extensions.commons.operations.InsertFragmentOperation', 
            arg-fragment, '{f:getFragment(.)}',
            arg-insertLocation, '.',
            {$insertPosition}
            arg-schemaAware, false
        ), 
        transparent, true,
        actionContext, element,
        showIcon, true
    )
        </xsl:text>
    </xsl:template>
     
    <!--  Placeholders  -->
     <xsl:template match="contentModel" mode="placeholders2">
         <xsl:if test="empty(key('element', @parent))">
            <xsl:text expand-text="yes">
@media oxygen {{
{@parent} {{ 
    -oxy-show-placeholder:always;
}}}}
            </xsl:text>
         </xsl:if>
         <xsl:apply-templates mode="placeholders2"/>
     </xsl:template>
    
     <xsl:template match="element[not(@empty = 'yes')][not(@table = 'yes')]" mode="placeholders2">
            <xsl:text expand-text="yes">
@media oxygen {{
{ancestor::contentModel/@parent} > {@name}{@placeholderFilter} {{ 
    -oxy-placeholder-content:" {f:getLongName(.)} ";
    -oxy-show-placeholder:always;
}}}}
            </xsl:text>
    </xsl:template>
    <xsl:template match="text()" mode="placeholders2"/>
    
    <!--  Delete actions  -->
    <xsl:template match="element[not(@occurs='1') or (../@occurs and not(../@occurs='1'))]" mode="deleteAction2">
        <xsl:variable name="filter" select="
                    if (@name = /processedActions/actions/contentModel/@parent) 
                    then ':empty ' 
                    else ''
        "/>
        <xsl:text expand-text="yes">
@media oxygen {{            

{ancestor::contentModel/@parent} > {@name}{$filter}:-oxy-delete {{
  background-color:rgba(210, 200, 200, 0.20);
}}

{ancestor::contentModel/@parent} > {@name}{$filter}:after({$actionsLayerDelete}) {{
    content:
        " "
        oxy_button(
            color, #CC5400,
            action, oxy_action(
                name, '[X]', 
                icon, '/images/Remove16.png',
                description, oxy_concat('Delete the current "', oxy_local-name(), '" element'), 
                operation, 'ro.sync.ecss.extensions.commons.operations.DeleteElementOperation'
            ), 
            transparent, true,
            hoverPseudoclassName, '-oxy-delete'
            showIcon, true);    
    ;
}}}}
        </xsl:text>
    </xsl:template>
    <xsl:template match="text()" mode="deleteAction2"/>
    
    <xsl:function name="f:getLongName" as="xs:string">
        <xsl:param name="element" as="element()"/>
        <xsl:value-of select="
            if ($element/@longName) then $element/@longName 
            else string-join(for $i in tokenize($element/@name, '-') return f:capitalizeFirstLetter($i), ' ')"/>
    </xsl:function>
    <xsl:function name="f:getDescription" as="xs:string">
        <xsl:param name="element" as="element()"/>
        <xsl:value-of select="
            if ($element/description) then $element/description
            else concat('Insert ', lower-case(f:getLongName($element)))"/>
    </xsl:function>
    <xsl:function name="f:getFragment" as="xs:string">
        <xsl:param name="element" as="element()"/>
        <xsl:value-of select="
            if ($element/fragment) then normalize-space($element/fragment)
            else concat('&lt;', $element/@name, '>', '${caret}', '&lt;/', $element/@name, '>')"/>
    </xsl:function>
    <xsl:function name="f:capitalizeFirstLetter">
        <xsl:param name="s"/>
        <xsl:value-of select="concat(upper-case(substring($s, 1, 1)), substring($s, 2))"/>
    </xsl:function>


    <!--  Temporary convert to an XML structure  -->
    <xsl:template match="contentModel[@repeat=('+', '*')]" mode="actions">
        <xsl:variable name="parent" select="@parent"/>
        <xsl:variable name="count" select="count(*)"/>
        <empty>
            <xsl:for-each select="*">
                <emptyParent parent="{$parent}" level="{position()}">
                    <xsl:copy-of select="."/>
                </emptyParent> 
            </xsl:for-each>
        </empty>
        <firstlast>
            <xsl:for-each select="*">
                <xsl:variable name="particle" select="."/>
                <xsl:variable name="index" select="position()"/>
                <!-- Parent    ??? firstChild -->            
                
                <xsl:for-each select="self::element, element">
                    <xsl:variable name="child" select="@name"/>
                    <xsl:for-each select="$particle/preceding-sibling::*">
                        <parent-firstChild child="{$child}" parent="{$parent}" level="{$index - position()}">
                            <xsl:copy-of select="."/>
                        </parent-firstChild>
                    </xsl:for-each>
                    <xsl:variable name="preceding" select="count($particle/preceding-sibling::*)"/>
                    <xsl:for-each select="$particle/following-sibling::*">
                        <parent-firstChild child="{$child}" parent="{$parent}" level="{$preceding + position()}">
                            <xsl:copy-of select="."/>
                        </parent-firstChild>
                    </xsl:for-each>
                    <parent-firstChild child="{$child}" parent="{$parent}" level="{$count}">
                        <xsl:copy-of select="."/>
                    </parent-firstChild>
                </xsl:for-each>
                
                <!-- Parent    lastChild ??? -->  
                <xsl:for-each select="self::element, element">
                    <xsl:variable name="child" select="@name"/>
                    <xsl:for-each select="$particle/following-sibling::*">
                        <parent-lastChild child="{$child}" parent="{$parent}" level="{position()}">
                            <xsl:copy-of select="."/>
                        </parent-lastChild>
                    </xsl:for-each>
                    <xsl:variable name="following" select="count($particle/following-sibling::*)"/>
                    <xsl:for-each select="$particle/preceding-sibling::*">
                        <parent-lastChild child="{$child}" parent="{$parent}" level="{$following + position()}">
                            <xsl:copy-of select="."/>
                        </parent-lastChild>
                    </xsl:for-each>
                    <parent-lastChild child="{$child}" parent="{$parent}" level="{$count}">
                        <xsl:copy-of select="."/>
                    </parent-lastChild>
                </xsl:for-each>
            </xsl:for-each>
        </firstlast>
        <repeatable>
            <xsl:for-each select="*">
                <xsl:variable name="particle" select="."/>
                <!-- level 0, repeatable particles -->
                <xsl:if test="@occurs=('+', '*')">
                    <xsl:for-each select="self::element, element">
                        <parent-child-repeat child="{@name}" parent="{$parent}" level="0">
                            <xsl:copy-of select="$particle"/>
                        </parent-child-repeat>
                    </xsl:for-each>
                </xsl:if>                
            </xsl:for-each>
        </repeatable>
        <between>
            <xsl:for-each select="*">
                <xsl:variable name="index" select="position()"/>
                <xsl:variable name="list">
                    <list>
                        <xsl:copy-of select="."/>
                        <xsl:for-each select="following-sibling::*">
                            <xsl:copy-of select="."/>
                        </xsl:for-each>
                        <xsl:for-each select="../*[position() &lt;= $index]">
                            <xsl:copy-of select="."/>
                        </xsl:for-each>
                    </list>
                </xsl:variable>
                
                <xsl:variable name="referenceIndex" select="$count+1"/>
                <!-- Parent   preceding ??? reference -->            
                <xsl:variable name="referenceParticle" select="$list/list/*[$referenceIndex]"/>
                
                <xsl:for-each select="$referenceParticle/preceding-sibling::*">
                    <xsl:variable name="insertParticle" select="."/>
                    <xsl:variable name="insertIndex" select="position()"/>
                    <xsl:for-each select="$insertParticle/preceding-sibling::*">
                        <xsl:variable name="precedingParticle" select="."/>
                        <!-- parent: precedingParticle  insertParticle referenceParticle -->
                        <xsl:for-each select="$referenceParticle/self::element, $referenceParticle/element">
                            <xsl:variable name="ref" select="@name"/>
                            <xsl:for-each select="$precedingParticle/self::element, $precedingParticle/element">
                                <parent-child-reference parent="{$parent}" preceding="{@name}" reference="{$ref}" level="{$referenceIndex - $insertIndex}">
                                    <xsl:copy-of select="$insertParticle"/>                                                                                            
                                </parent-child-reference>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:for-each>
                </xsl:for-each>
            </xsl:for-each>
        </between>
    </xsl:template>
    <xsl:template match="contentModel" mode="actions">
        <xsl:variable name="parent" select="concat(@prefilter, @parent, @filter)"/>
        <empty>
            <xsl:for-each select="*">
                <emptyParent parent="{$parent}" level="{position()}">
                    <xsl:copy-of select="."/>
                </emptyParent> 
            </xsl:for-each>
        </empty>
        <firstlast>
            <xsl:for-each select="*">
                <xsl:variable name="particle" select="."/>
                <xsl:variable name="index" select="position()"/>
                <!-- Parent    ??? firstChild -->            
                <xsl:if test="$index > 1">
                    <xsl:for-each select="self::element, element">
                        <xsl:variable name="child" select="@name"/>
                        <xsl:for-each select="$particle/preceding-sibling::*">
                            <parent-firstChild child="{$child}" parent="{$parent}" level="{$index - position()}">
                                <xsl:copy-of select="."/>
                            </parent-firstChild>
                        </xsl:for-each>
                    </xsl:for-each>
                </xsl:if>
                <!-- Parent    lastChild ??? -->  
                <xsl:if test="$index &lt; last()">
                    <xsl:for-each select="self::element, element">
                        <xsl:variable name="child" select="@name"/>
                        <xsl:for-each select="$particle/following-sibling::*">
                            <parent-lastChild child="{$child}" parent="{$parent}" level="{position()}">
                                <xsl:copy-of select="."/>
                            </parent-lastChild>
                        </xsl:for-each>
                    </xsl:for-each>
                </xsl:if>
            </xsl:for-each>
        </firstlast>
        <repeatable>
            <xsl:for-each select="*">
                <xsl:variable name="particle" select="."/>
                <!-- level 0, repeatable particles -->
                <xsl:if test="@occurs=('+', '*')">
                    <xsl:for-each select="self::element, element">
                        <parent-child-repeat child="{@name}" parent="{$parent}" level="0">
                            <xsl:copy-of select="$particle"/>
                        </parent-child-repeat>
                    </xsl:for-each>
                </xsl:if>                
            </xsl:for-each>
        </repeatable>
        <between>
            <xsl:for-each select="*">
                <!-- Parent   preceding ??? reference -->            
                <xsl:variable name="referenceParticle" select="."/>
                <xsl:variable name="referenceIndex" select="position()"/>
                <xsl:if test="$referenceIndex > 1">
                    <xsl:for-each select="$referenceParticle/preceding-sibling::*">
                        <xsl:variable name="insertParticle" select="."/>
                        <xsl:variable name="insertIndex" select="position()"/>
                        <xsl:for-each select="$insertParticle/preceding-sibling::*">
                            <xsl:variable name="precedingParticle" select="."/>
                            <!-- parent: precedingParticle  insertParticle referenceParticle -->
                            <xsl:for-each select="$referenceParticle/self::element, $referenceParticle/element">
                                <xsl:variable name="ref" select="@name"/>
                                <xsl:for-each select="$precedingParticle/self::element, $precedingParticle/element">
                                    <parent-child-reference parent="{$parent}" preceding="{@name}" reference="{$ref}" level="{$referenceIndex - $insertIndex}">
                                        <xsl:copy-of select="$insertParticle"/>                                                                                            
                                    </parent-child-reference>
                                </xsl:for-each>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:for-each>
                </xsl:if>
            </xsl:for-each>
        </between>
    </xsl:template>
</xsl:stylesheet>