//CustomEvent polyfill for IE11
(function() {

  if (typeof window.CustomEvent === "function")
    return false;

  function CustomEvent(event, params) {
    params = params || {
      bubbles : false,
      cancelable : false,
      detail : undefined
    };
    var evt = document.createEvent('CustomEvent');
    evt.initCustomEvent(event, params.bubbles, params.cancelable,
        params.detail);
    return evt;
  }

  CustomEvent.prototype = window.Event.prototype;

  window.CustomEvent = CustomEvent;
})();

sync.rest.initAutoRecovery();

var templates_div = document.getElementById('templateChooser');

var cD = goog.dom.createDom;

var templates_container = cD('div', {
  'id': 'myId',
  'class': 'new-file-templates-container',
  'style': 'margin: 0px'
});

var TemplateContentRequest = function (tmplURL) {
  this.execute = function () {
    var request = new XMLHttpRequest();

    // Return it as a Promise
    return new goog.Promise(function (resolve, reject) {
      request.onreadystatechange = function () {
        // Only run if the request is complete
        if (request.readyState !== 4) return;

        if (request.status >= 200 && request.status < 300) {
          resolve(request);
        } else {
          // If failed
          reject({
            status: request.status,
            statusText: request.statusText
          });
        }
      };

      request.open('GET', tmplURL, true);
      request.send();
    });
  }
};

function templateSelectedCallback(selectedTmpl) {
  if(selectedTmpl) {
    var templateURL = selectedTmpl.getDownloadUrl();
    var eventData = {
      selectedTmpl: selectedTmpl,
      templateContentRequest: new TemplateContentRequest(templateURL)
    };
    var event = new CustomEvent('templateChooserEvent', {detail: eventData});
    window.frameElement.dispatchEvent(event);
  }
}

function templateSubmittedCallback() {
  // NOP
}

goog.dom.appendChild(templates_div, templates_container);

sync.react.render(sync.react.createElement(sync.view.TemplateChooser, {
  onTemplateSelected: templateSelectedCallback,
  onTemplateSubmitted: templateSubmittedCallback
}), templates_container);