function showError(msgKey) {
  let errorEl = document.querySelector(".auth-error");
  errorEl.textContent = tr(msgs[msgKey]);
  errorEl.setAttribute("data-oxy-i18n-key", msgKey);
  errorEl.classList.remove("hide");
}

function renderAuthButton(authProvider) {
  let button = document.querySelector(".auth-button");
  button.classList.remove("hide");
  button.setAttribute("href", "../rest/app-authentication/auth-redirect?provider=" + encodeURIComponent(authProvider.authProviderName));

  let buttonText = document.querySelector(".auth-button-text");
  buttonText.textContent = tr(msgs.AUTHENTICATE_WITH, { '$auth_provider_name': authProvider.authProviderName});
  buttonText.setAttribute("data-oxy-i18n-key", "AUTHENTICATE_WITH");
  buttonText.setAttribute("data-oxy-i18n-arg-auth_provider_name", authProvider.authProviderName);

  if (authProvider.authProviderIcon) {
    let icon = document.querySelector(".auth-button-icon");
    icon.setAttribute("src", authProvider.authProviderIcon);
    icon.setAttribute("alt", authProvider.authProviderName);
  }
}

function showAuthorizationInfo(authProvider) {
  if (authProvider.askingForAuthorization) {
    let para = document.querySelector(".authorization-info");
    para.classList.remove("hide");
    para.textContent = tr(msgs.AUTHORIZATION_INFO, { '$auth_provider_name': authProvider.authProviderName});
    para.setAttribute("data-oxy-i18n-key", "AUTHORIZATION_INFO");
    para.setAttribute("data-oxy-i18n-arg-auth_provider_name", authProvider.authProviderName);
  }
}

fetch('../rest/app-authentication/provider')
    .then(response => response.json())
    .then(authProvider => {
      if (authProvider) {
        renderAuthButton(authProvider);
        showAuthorizationInfo(authProvider);
      } else {
        showError("AUTHENTICATION_NO_POSSIBLE");
      }
    })
    .catch((e) => {
      console.warn(e);
      showError("AUTHENTICATION_DETAILS_FAILED");
    });

function showAdminLink() {
  let elem = document.querySelector(".admin-link");
  elem.classList.remove("hide");

  let langDiv = document.querySelector(".langDiv");
  langDiv.classList.remove("left");

  elem.setAttribute("title", tr(msgs.GO_TO_ADMIN_PAGE_));
  elem.setAttribute("data-oxy-i18n-key", "GO_TO_ADMIN_PAGE_");
  let span = document.querySelector(".admin-link .admin-link-content");
  span.textContent = tr(msgs.ADMINISTRATION_PAGE_);
  span.setAttribute("data-oxy-i18n-key", "ADMINISTRATION_PAGE_");
}

fetch('../rest/app-authentication/show-admin-link')
  .then(response => response.json())
  .then(shouldShowAdminLink => {
    if (shouldShowAdminLink) {
      showAdminLink();
    }
  });


