window.addEventListener('load', function() {

  // Check for oidc provider name
  let isOidcConfigured = false;
  fetch('../admin-login/oidc-provider')
    .then(response => {
      if (response.status === 200) {
        isOidcConfigured = true;
        return response.text();
      } else {
        throw new Error('Provider not found');
      }
    })
    .then(providerName => {
      if (providerName) {
        // Show OIDC login button and hide the form
        let loginContainer = document.querySelector('#oidc-login-container');
        let loginButton = document.querySelector('#oidc-login');
        loginContainer.classList.remove("hidden-section");

        loginButton.textContent = tr(msgs.AUTHENTICATE_WITH, { '$auth_provider_name': providerName});
        loginButton.setAttribute("data-oxy-i18n-key", "AUTHENTICATE_WITH");
        loginButton.setAttribute("data-oxy-i18n-arg-auth_provider_name", providerName);
      }
    })
    .catch(error => {
      if (isOidcConfigured === true) {
        console.error(error);
      } else {
        let loginFormContainer = document.querySelector('#user-pass-login');
        if (loginFormContainer) {
          loginFormContainer.classList.remove("hidden-section");
        }

        // Make the request xhr request to admin-login from here and add error messages when needed.
        var loginForm = document.querySelector('form[name=loginform]');
        var loginFormButton = loginForm.querySelector('button');
        loginForm.addEventListener('submit', function(event) {
          event.preventDefault();

          var username = loginForm.querySelector('input[name=username]').value;
          var password = loginForm.querySelector('input[name=password]').value;

          var xhr = new XMLHttpRequest();
          xhr.open('POST', '../admin-login');
          xhr.onreadystatechange = function() {
            if (xhr.readyState === 4) {
              if (xhr.status === 200) {
                window.location.reload();
              } else {
                loginForm.classList.remove("oxy-spinner");
                loginFormButton.removeAttribute('disabled');
                var msgHolder = document.querySelector('.msg_holder');
                if (msgHolder) {
                  msgHolder.textContent = '';

                  var message = document.createElement('div');
                  message.className = 'message';
                  message.textContent = tr(msgs.INVALID_CREDENTIALS_);

                  msgHolder.appendChild(message);
                }
              }
            }
          };
          xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
          xhr.setRequestHeader('X-Requested-With', 'WA');
          xhr.send('username=' + encodeURIComponent(username.trim()) +
            '&password=' + encodeURIComponent(password));
          loginForm.classList.add("oxy-spinner");
          loginFormButton.setAttribute('disabled', '');
        });
      }
    });
});