namespace('sync.view');


/**
 * Handler for dragging links to the editor (author editor).
 *
 * @param {string} baseUrl The editor URL.
 * @param {ActionsManagerImpl} actionsManager The actions manager.
 * @param {Controller} controller The controller.
 * @param {HTMLElement} docWrapper The document wrapper.
 * @param {SelectionManager} selectionManager The selection manager.
 * @param {LayoutChangeTracker} layoutChangeTracker The layout change tracker.
 * @param {ConcurrentEditingManagerImpl} concurrentEditingManager The concurrent editing manager.
 * @param {Scheduler} scheduler The scheduler.
 * @constructor
 * @extends {goog.Disposable}
*/
sync.view.ResourceDragHandler = function(
  baseUrl,
  actionsManager,
  controller,
  docWrapper,
  selectionManager,
  layoutChangeTracker,
  concurrentEditingManager,
  scheduler
) {};

/**
 * The reference media types.
 *
 * @type {{FROM_EDITOR: string, CUSTOM_URL: string}}
 */
sync.view.ResourceDragHandler.TYPES = {
  CUSTOM_URL: 'application/oxy-reference',
  FROM_EDITOR: 'application/oxy-from-editor'
}

/**
 * Get the editor element for listening for drag/drop events.
 * @returns {Element | null}
 */
sync.view.ResourceDragHandler.prototype.getEditorDragElement = function() {};


/**
 * Add custom data to the dataTransfer object.
 * Should be used on dragstart.
 *
 * @param {DataTransfer} dataTransfer The dataTransfer object.
 * @param {object} obj The object containing custom data to be passed.
 *
 * @deprecated use {@link sync.view.ResourceDragHandler#addCustomDataOfType} instead.
 */
sync.view.ResourceDragHandler.prototype.addCustomData = function(dataTransfer, obj) {};

/**
 * Add custom data of a specific type to the dataTransfer object.
 * To be used on dragstart.
 * @param {string} type The type of data to add to the object.
 * @param {DataTransfer} dataTransfer The dataTransfer object.
 * @param {object} obj The object containing custom data to be passed.
 *
 * @since 21.1.1
 */
sync.view.ResourceDragHandler.prototype.addCustomDataOfType = function(type, dataTransfer, obj) {};

/**
 * Add custom data of a specific type to the dataTransfer object.
 * To be used on dragstart.
 * @param {string} type The type of data to add to the object.
 * @param {DataTransfer} dataTransfer The dataTransfer object.
 * @param {object} obj The object containing custom data to be passed.
 */
sync.view.ResourceDragHandler.addCustomDataOfType = function(type, dataTransfer, obj) {};

export default sync.view.ResourceDragHandler;