
namespace('sync.api');


/**
 * A custom message sent by the server-side code.
 *
 * @constructor
 */
sync.api.WebappMessage = function(messageJSON) {
 /**
  * The title of the message: usually displayed in the header of the
  * notification pop-up.
  *
  * @type {string}
  */
 this.title = null;
 /**
  * The actual content of the message - you can use this to send information
  * about the message to be displayed to the user.
  *
  * @type {string}
  */
 this.message = null;
 /**
  * The type of the message set by the server-side code.
  *
  * @type {number}
  */
 this.type = null;
 /**
  * true if the message was generated by some user action, as opposed an error regarding
  * framework's consistency: e.g. parsing error in the CSS.
  *
  * Error messages with this flag set to false should not be displayed visibly to the user,
  * but in the browser's console instead.
  *
  * @type {boolean}
  */
 this.userGenerated = null;
 /**
  * The url of the resource for which the message was generated (available only for messages generated for UserActionRequiredEvents).
  *
  * @type {string}
  */
 this.url = null;
};

/**
 * The type of open in system application webapp message.
 *
 * @type {number}
 */
sync.api.WebappMessage.SYSTEM_APPLICATION_MESSAGE = -1;

/**
 * The type of a Webapp custom message.
 *
 * @type {number}
 */
sync.api.WebappMessage.CUSTOM_MESSAGE = 3;






