namespace('sync.api');

/**
 * @typedef {Object} sync.api.FileBrowsingDialog.Options options The options used to configure the file browsing dialog.
 * @property {string=} options.root The root url of the file repository on which the browsing will be performed.
 * @property {string=} options.initialUrl The URL of the folder where the dialog points to initially.
 * @property {sync.api.FileBrowsingDialog~listFolderFunction=} options.listFolder The function to call to retrieve files -
 * by default the server-side ro.sync.net.protocol.FileBrowsingConnection.listFiles() method is called.
 * @extends {sync.api.UrlChooser}
*/
/**
 * Browsing dialog for files in a remote file repository.
 *
 * The file repositories suitable to be browsed using this dialog contain files that can be identified by URLs. The
 * URLs should be composed of two parts:
 * <ul>
 *   <li>The file repository URL. E.g. the URL of a branch of a GitHub project, or an WebDAV server. When editing a
 *   file, browsing for external references link: images, content references, DITA Maps happens in the repository
 *   of the edited file. However, when trying to open or create a new file, the users should be allowed to change the
 *   file repository that they are using.
 *   <li>The path to the file. In order to change the file path, users can navigate the hierarchical of the repository.
 * </ul>
 *
 * @param {sync.api.FileBrowsingDialog.Options=} options The options used to configure the File Browsing Dialog.
 *
 * @constructor
 * @extends sync.api.UrlChooser
 */
sync.api.FileBrowsingDialog = function(options) {
  // The root
  // Set the properties of the file browser
  /**
   * The properties that control the file browser.
   *
   * @type {sync.api.FileBrowsingDialog.Options}
   */
  this.fileBrowserProps = null;
};

/**
 * A descriptor for a folder entry.
 *
 * @param {string} name The name of the entry.
 * @param {boolean} folder true if the entry is a folder.
 * @constructor
 */
sync.api.FileBrowsingDialog.FolderEntryDescriptor = function(name, folder) {
  /**
   * The name of the entry.
   *
   * @type {string}
   */
  this.name = null;
  /**
   * true if the entry is a directory.
   *
   * @type {boolean}
   */
  this.folder = null;
};

/**
 * Callback that receives the folder entries.
 *
 * @callback sync.api.FileBrowsingDialog~listFolderSuccessCallback
 * @param {Array.<sync.api.FileBrowsingDialog.FolderEntryDescriptor>} folderEntries The list of the URLs of the folder
 * entries.
 */

/**
 * Callback that returns the contents of the given folder.
 *
 * @callback sync.api.FileBrowsingDialog~listFolderFunction
 * @param {string} folderUrl The URL of the folder to list.
 * @param {sync.api.FileBrowsingDialog~listFolderSuccessCallback} successCalback The function to call when the folder listing is available.
 * @param {function(object)} failureCallback The function to call when there was a failure retrieving folder content,
 * passing in the exception.
 */

/**
 * Shows an error message inline.
 *
 * @param {string} message The error message.
 * @param {InplaceNotificationReporter.types=} errorType The type of the error message, error by default.
 */
sync.api.FileBrowsingDialog.prototype.showErrorMessage = function(message, errorType) {};

/**
 * @override
 */
sync.api.FileBrowsingDialog.prototype.chooseUrl = function(context, chosen, purpose) {};

/**
 * @override
 */
sync.api.FileBrowsingDialog.prototype.supports = function() {};

/**
 * @override
 */
sync.api.FileBrowsingDialog.prototype.supportsOperation = function() {};

/**
 * Sets the root URL, above which navigation is prohibited.
 *
 * @param {string=} root the root url of the server.
 */
sync.api.FileBrowsingDialog.prototype.setRootUrl = function(root) {};

/**
 * @return {string} The root URL of the file browser.
 *
 * @since 20.1.1
 */
sync.api.FileBrowsingDialog.prototype.getRootUrl = function() {};

/**
 * Getter for the url chooser's event target.
 *
 * @return {goog.events.EventTarget} target the object on which to listen
 * for url chooser specific events.
 */
sync.api.FileBrowsingDialog.prototype.getEventTarget = function() {};

/**
 * Refresh the url chooser.
 *
 * Refresh the url chooser in case the chooser does not reflect the actual resource state.
 */
sync.api.FileBrowsingDialog.prototype.refresh = function() {};

/**
 * Event types generated by the File Browser.
 *
 * @enum {string}
 */
sync.api.FileBrowsingDialog.EventTypes = {
  /**
   * The Event dispatched when some user action is required in order to be able to list the content of a folder.
   * <br/>
   * See {@link sync.api.FileBrowsingDialog.UserActionRequiredEvent} for more details.
   */
  USER_ACTION_REQUIRED: 'user_action_required'
};

/**
 * The Event dispatched when some user action is required in order to be able
 * to list the content of a folder.
 *
 * <hr/>
 * <p>
 * Example of listening for this event:
 * </p>
 * <pre>
 * fileBrowsingDialog.getEventTarget().listen(sync.api.FileBrowsingDialog.EventTypes.USER_ACTION_REQUIRED, function(e) {
 *   // e is of type sync.api.FileBrowsingDialog.UserActionRequiredEvent
 * });
 * </pre>
 *
 * @param {string} message The message sent by the server-side code.
 *
 * @constructor
 */
sync.api.FileBrowsingDialog.UserActionRequiredEvent = function(message) {
  /**
   * The type of the event: {@link sync.api.FileBrowsingDialog.EventTypes.USER_ACTION_REQUIRED};
   *
   * @type {string}
   */
  this.type = null;

  /**
   * The message to show to the user when an action is required from him/her.
   * @type {sync.api.WebappMessage}
   */
  this.message = null;
};

/**
 * Switches the dialog into repository configuration editing mode.
 */
sync.api.FileBrowsingDialog.prototype.switchToRepoConfig = function() {};

/**
 * The default height for the filebrowser. (WA-312)
 * @type {number}
 */
sync.api.FileBrowsingDialog.DEFAULT_HEIGHT = 600;

/**
 * Switches the dialog into file browsing mode.
 */
sync.api.FileBrowsingDialog.prototype.switchToFileBrowsing = function() {};

/**
 * Clear the file browsing data (current url, selected url).
 */
sync.api.FileBrowsingDialog.prototype.clearFileBrowsingData = function() {};

/**
 * Opens the following URL.
 *
 * If the URL denotes a File, the file is chosen.
 * If the URL denotes a Folder, the dialog switches to that folder.
 *
 * @param {string} url The URL to open.
 * @param {boolean} isFile true if the url points to a file rather than to a folder.
 * @param {goog.events.Event=} e The event that made you want to open the URL. If the call is made outside
 * an event handler, pass null.
 */
sync.api.FileBrowsingDialog.prototype.openUrl = function(url, isFile, e) {};

/**
 * @return {string} the URL of the current folder.
 */
sync.api.FileBrowsingDialog.prototype.getCurrentFolderUrl = function() {};

/**
 * @return {string} The name of the selected file.
 */
sync.api.FileBrowsingDialog.prototype.getFileName = function() {};

/**
 * Called when the repository configuration should be opened.
 *
 * @param {HTMLElement} element The container element of the repo editing UI.
 * @param {goog.events.Event} e The event that triggered the opening - you can cancel it.
 */
sync.api.FileBrowsingDialog.prototype.handleOpenRepo = function(element, e) {};

/**
 * Render the repo editing UI.
 *
 * @param {HTMLElement} element The container element.
 */
sync.api.FileBrowsingDialog.prototype.renderRepoEditing = function(element) {};

/**
 * Render the repo preview UI.
 *
 * @param {HTMLElement} element The container element.
 */
sync.api.FileBrowsingDialog.prototype.renderRepoPreview = function(element) {};

