namespace('sync.actions');


/**
 * Drop action part of a drag-and-drop.
 * This handles only the drop part.
 *
 * @param {sync.select.SavedSelection} sourceSelection Selection of dragged source.
 * @param {sync.position.RelativeContentPosition} destPosition Drop position.
 * @param {ControllerBase} controller The controller.
 * @param {boolean=} doCopy True to copy, otherwise move content. By default move is performed.
 *
 * @constructor
 * @extends {Action}
*/
sync.actions.DropAction = function(sourceSelection, destPosition, controller, doCopy = false) {};

/**
 * @override
 */
sync.actions.DropAction.prototype.execute = function() {};

