
namespace('sync.api');


/**
 * Instance of {@link sync.api.EditingSupport} used when the current document is an XML document opened in "Author" mode.
 *
 * @param {sync.api.Workspace.LoadingOptions} options The options to be used by the editing support.
 *
 * @constructor
 * @extends {sync.api.EditingSupport}
*/
sync.api.AuthorEditingSupport = function(options) {};


/**
 * <p>Registers an enhancer for a type of form controls.
 *
 * <p>This registration should be performed before the editor is loaded, so that the enhancer can
 * be used for the initial rendering of the document.
 *
 * @param {string} name The type of the form-control, which is the fully qualified name of the
 * Java WebappFormControlRenderer class.
 * @param {function(HTMLElement, Editor)} enhancer The constructor for an instance of {@link sync.formctrls.Enhancer}
 * that will be used to enhance form controls rendered by the specified Java renderer.
 *
 */
sync.api.AuthorEditingSupport.prototype.registerEnhancer = function(name, enhancer) {};

/**
 * Returns the change tracking manager for the current editor.
 *
 * @return {sync.api.ChangeTrackingManager} the change tracking manager.
 */
sync.api.AuthorEditingSupport.prototype.getChangeTrackingManager = function() {};

/**
 * Returns the handler for custom persistent highlights.
 *
 * @return {sync.api.PersistentHighlightsManager|null} The persistent highlights manager.
 *
 * @since 22.1
 */
sync.api.AuthorEditingSupport.prototype.getPersistentHighlightsManager = function() {};

/**
 * Returns the document node of the XML DOM model.
 *
 * The returned node partially respects the DOM Level 3 specification with some limitations:
 * <li> operations that modify the DOM are not supported.
 * <li> Node.baseURI works for nodes included from other documents, but does not
 *   take the xml:base attribute into acount.
 * <li> the Attribute.isId function does not take schema information into account
 * <li> TextNode.wholeText does not take into account entity reference nodes.
 * <li> isElementContentWhitespace always returns false
 * <li> the schemaTypeInfo property is not supported.
 * <li> the documentType property of document always returns null.
 * <li> the API may return multiple JS objects corresponding to the same XML node - use the isSameNode method to
 * detect these cases.
 *
 * <p>Note that the document may change during an editing session - for example when replacing it in text mode. In this
 * case a different instance is returned.
 *
 * @return {Document} The document node of the XML DOM model.
 * @since 22.1
 */
sync.api.AuthorEditingSupport.prototype.getDocument = function() {};

/**
 * Returns the Author widgets factory.
 *
 * @since 22.1
 * @return {sync.api.AuthorWidgetsFactory} The Author editing support widgets factory.
 */
sync.api.AuthorEditingSupport.prototype.getWidgetsFactory = function() {};


/**
 * Event types generated by this editing support.
 *
 * @enum {string}
 */
sync.api.AuthorEditingSupport.EventType = {
  /**
   * Generated before the editor content changes.
   * <br/>
   * See {@link sync.api.AuthorEditingSupport.AuthorModelChangedEvent} for more details.
   */
  BEFORE_MODEL_CHANGED: 'AES_before_model_changed',
  /**
   * Generated after the editor content changes.
   * <br/>
   * See {@link sync.api.AuthorEditingSupport.AuthorModelChangedEvent} for more details.
   */
  MODEL_CHANGED: 'AES_model_changed'
};

/**
 * This event is triggered when the edited content changes.
 *
 * <hr/>
 * <p>
 * This event is triggered on an {@link sync.api.AuthorEditingSupport}. Here is an example of listening for this event:
 * </p>
 * <pre>
 * editingSupport.listen(sync.api.AuthorEditingSupport.EventType.MODEL_CHANGED, function(e) {
 *   // e is of type sync.api.AuthorEditingSupport.AuthorModelChangedEvent
 * });
 * </pre>
 *
 * @param {string} type The event type.
 * @param {sync.api.AuthorEditingSupport.ModelChangedMutation} mutation The object describing the model changes.
 *
 * @constructor
 * @since 22.1
 */
sync.api.AuthorEditingSupport.AuthorModelChangedEvent = function(type, mutation) {
 /**
  * @type {sync.api.AuthorEditingSupport.ModelChangedMutation}
  */
 this.mutation = null;
};

/**
 * <p>Object describing the changes made to the document.
 *
 * <p>The mutation can represent nodes as inserted, deleted or updated. The semantic of an updated node is that something
 * changed in the subtree rooted at that element. These changes include attribute changes.
 * <p>It can happen that, when a node is deleted or inserted the mutation is reported as an update in the subtree
 * rooted at its parent element.
 *
 * @param {Node[]} updated The nodes updated during this mutation.
 * @param {Node[]} deleted The nodes deleted during this mutation.
 * @param {Node[]} inserted The nodes inserted during this mutation.
 * @constructor
 * @since 22.1
 */
sync.api.AuthorEditingSupport.ModelChangedMutation = function(updated, deleted, inserted) {
 /**
  * @type {Node[]}
  */
 this.updated = null;
 /**
  * <p><b>Important:</b> These nodes are available only during a {@link sync.api.AuthorEditingSupport.EventType.BEFORE_MODEL_CHANGED} event.
  *
  * <p>During a {@link sync.api.AuthorEditingSupport.EventType.MODEL_CHANGED} event
  * these nodes are all detached nodes. They can only be used to count the number of deleted nodes.
  *
  * @type {Node[]}
  */
 this.deleted = null;
 /**
  * <p><b>Important:</b> These nodes are available only during a {@link sync.api.AuthorEditingSupport.EventType.MODEL_CHANGED} event.
  *
  * <p>During a {@link sync.api.AuthorEditingSupport.EventType.BEFORE_MODEL_CHANGED} event
  * these nodes are all detached nodes. They can only be used to count the number of inserted nodes.
  *
  * @type {Node[]}
  */
 this.inserted = null;
};

