namespace('sync.api');

/**
 * Base class for selection manager.
 *
 * @constructor
 * @since 27.0
 * @extends {goog.events.EventTarget}
*/
sync.api.SelectionManagerCore = function() {};



/**
 * @return {sync.api.SelectionCore} The selection of the document.
 */
sync.api.SelectionManagerCore.prototype.getSelection = function() {};


/**
 * @param {sync.api.SelectionCore} sel The selection to be set.
 * @param {{focus: boolean}=} options Options object. <ul>
 *   <li> focus: by default <code>true</code>. When false, a fake selection is rendered and the focus is not moved
 *      to the editor.
 * </ul>
 */
sync.api.SelectionManagerCore.prototype.setSelection = function(sel, options) {};

/**
 * Scroll the editor until the content represented by the selection is visible.
 * @param {sync.api.SelectionCore} selection The selection to scroll into view.
 */
sync.api.SelectionManagerCore.prototype.scrollSelectionIntoView = function(selection) {};

/**
 * The selection changed event type.
 *
 * @enum {String}
 */
sync.api.SelectionManagerCore.EventType = {
  /**
   * Event triggered when the document selection was changed.
   */
  SELECTION_CHANGED: 'selection-changed'
};

/**
 * @Deprecated Use {@link sync.api.SelectionManager} instead.
 */
sync.api.SelectionModel = {};

/**
 * The selection changed event type.
 *
 * @enum {String}
 *
 * @Deprecated Use {@link sync.api.SelectionManager.EventType} instead.
 */
sync.api.SelectionModel.EventType = {
  /**
   * Event triggered when the document selection was changed.
   */
  SELECTION_CHANGED: 'selection-changed'
};

export default sync.api.SelectionManagerCore;