namespace('sync.api');

/**
 * Base class for a selection.
 *
 * @interface
 * @constructor
 * @since 27.0
 */
sync.api.SelectionCore = function() {};

/**
 * Checks whether the selection is empty.
 *
 * @return {boolean} true if the selection is empty.
 */
sync.api.SelectionCore.prototype.isEmpty = function() {};

/**
 * Compare this selection with the given one.
 *
 * @param {sync.api.SelectionCore} sel The selection to compare with.
 *
 * @return {boolean} true if the two selection are equal.
 */
sync.api.SelectionCore.prototype.equals = function(sel) {};

/**
 * Computes the bounding rectangle of the selection.
 * @return {sync.api.math.Rect|null} Bounding rectangle or <code>null</code> if it cannot be computed.
 *                                   Its position is relative to the viewport.
 */
sync.api.SelectionCore.prototype.getBoundingClientRect = function() {};

sync.api.SelectionCore.Comparison = {
  BEFORE: 'before',
  EQUAL: 'equal',
  OVERLAP: 'overlap',
  AFTER: 'after'
};
/**
 * Compares this selection with another selection.
 * @param selection The selection to compare with.
 * @return {sync.api.SelectionCore.Comparison} The result of the comparison, telling if the given selection is before,
 * equal, overlapping or after this selection.
 * @since 27.1
 */
sync.api.SelectionCore.prototype.compare = function(selection) {};

/**
 * @return {sync.api.SelectionCore} a collapsed selection containing the start position of this selection.
 * @since 27.1
 */
sync.api.SelectionCore.prototype.collapseToStart = function() {};

/**
 * @return {sync.api.SelectionCore} a collapsed selection containing the end position of this selection.
 * @since 27.1
 */
sync.api.SelectionCore.prototype.collapseToEnd = function() {};

export default sync.api.SelectionCore;