<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>

<%@ page import="ro.sync.licenseservlet.*"%>
<%@ page import="java.util.Properties"%>

<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Insert title here</title>
</head>
<body>

	<%
	ServletContext servletContext = getServletContext();
	LicenseStore licenseStore = (LicenseStore) servletContext.getAttribute(BaseServletConstants.PARAM_LICENSE_STORE);
	
	boolean isBundledWithContentFusion = "true".equals(System.getProperty("com.oxygenxml.content.fusion.product"));
	boolean isBundledWithWebAuthor = "true".equals(System.getProperty("com.oxygenxml.webapp.product"));
	
	String licenseText = licenseStore.getLicenseTextFromDisk(licenseStore.getLicenseFile());
	String activationCode = licenseStore.getServerSignature();
	String serverUrl = licenseStore.getServerUrl();
	
	boolean signatureMismatch = false;

	String errorMessage = (String) request.getSession().getAttribute(BaseServletConstants.JSP_ERROR_MESSAGE);
	// Remove the "error" message after usage.
	request.getSession().removeAttribute(BaseServletConstants.JSP_ERROR_MESSAGE);
	
  String documentationURL = "";
  try {
    Properties prop = new Properties();
    prop.load(getServletContext().getResourceAsStream("/documentation.properties"));
    documentationURL = prop.getProperty("installation.setting.up.license.server").replace("${license.servlet.version}",
    BaseLicenseServlet.getVersionNoBuild());
  } catch (Exception e) {}

	if (errorMessage != null && !errorMessage.trim().isEmpty()) {
		errorMessage = errorMessage.replaceAll("\n", "<br/>").replaceAll("\r", "");
	%>

	<div class="error-msg">
		<a href="index.jsp" title="Close" class="close-button">x</a><%= errorMessage %>
	</div>
	<%
	} else if (licenseText != null && !licenseText.isEmpty()) {
		signatureMismatch = true;
		
	%>
	<div class="error-msg">
		The current license was already activated on a License Server. That
		License Server's Machine Signature does not match the current server's
		Machine Signature.<br /> <br /> <a
			href="https://www.oxygenxml.com/doc/ug-editor/topics/machine-signature-mismatch.html"
			target="_blank">Read documentation</a> or contact <a
			href="mailto:support@oxygenxml.com">support@oxygenxml.com</a> for
		more details.
	</div>
	<% } %>


	<% if(isBundledWithContentFusion) { %>
	<div class="error-msg valid-component">
		<a href="index.jsp" title="Close" class="close-button">x</a> This
		product requires a valid <i>Oxygen Content Fusion</i> license key.
	</div>
	<% } %>
	
	<h2>License Activation</h2>
  <p>
    For more information see <a target="_blank"
      href="<%=documentationURL%>"> Activating License Keys</a>
  </p>

  
  <h3>Activation Signature <code id="server-signature"><%= activationCode %></code></h3>


<!-- Content Fusion and Web Author do not support Server URL based activation.  -->
<% if( ! isBundledWithContentFusion && ! isBundledWithWebAuthor) { %>
	<form id="activationSignatureForm">
		<!-- Public server URL -->
		<div>
			<input type="checkbox" id="publicUrlOption" name="licenseOption"
				value="publicUrl"
        <% if (serverUrl != null && ! serverUrl.isEmpty()) {%>
          checked 
        <%}%>
				> <label for="publicUrlOption">Use the URL that client applications will use to access the License Server (recommended)
				<div class="server-url-input-section-info">
					i
					<div class="server-url-input-section-info--tooltip">
						<p>Use the URL client applications will use to access the
							server in the license key activation process. It can be an
							internal network URL and does not need to be accessible from
							outside the company.</p>
						<p>Client applications will receive a license only if they access the License Server using the configured Server URL.</p>
						<p>
							Enter the exact URL that Oxygen Applications will use to request
							a license. The URL should be in the format: 
							<i style="white-space: nowrap;">http(s)://my-domain:port/context-name<b>/license-servlet</b></i>
						</p>
					</div>
				</div>
			</label>

			<!-- Server URL input -->
			<div class="server-url-input-section">
				<span>Public URL</span> 
			   <!-- placeholder="The URL that Oxygen Applications will use to request a license" -->
				<input
					class="server-url-input-section-input" type="text"
					
	        <% if (serverUrl != null && ! serverUrl.isEmpty()) {%>
				  	value="<%=serverUrl%>"
          <%}%>
           
					placeholder="http(s)://my-domain:port/context-name/license-servlet">
			</div>
			<!-- server URL error message -->
			<div class="server-url-input-error">
				<p>
				<%
				String suggestedBaseUrlFormat = new StringBuilder()
					.append(request.getScheme())
					.append("://<b>[hostname]:[port]</b>")
					.append(request.getContextPath()).toString();
				%>
					The URL you provided is invalid. Please ensure it follows this format: <i
						style="white-space: nowrap;"><%= suggestedBaseUrlFormat %><b>/license-servlet</b></i>
				</p>
				<p>
					<b>Warning:</b> <i>localhost</i> and <i>127.0.0.1</i> are not allowed in the license activation
            process. Please specify a distinct hostname or FQDN.
				</p>
			</div>
		</div>
	</form>
	<!-- Activation Signature update error -->
	<div class="activation-signature-error-message">
	 <p>Failed to update Activation Signature configuration.</p>
	</div>
	
	
	<% } %>

	<h3>License Key</h3>
	<form id="noLicenseForm" action=<%=BaseServletConstants.HOME_URI%> method="POST">
		<input type="hidden" name="<%=BaseServletConstants.JSP_FORM%>"
			value="noLicenseForm">
		<!-- License text area  -->
		<textarea rows="22" cols="80"
			name="<%= BaseServletConstants.JSP_LICENSE_TEXT %>"
			placeholder="Paste license here..." id="noLicenseFormTextArea"></textarea>
		<input type="hidden" name="originalUrl" id="originalUrl"> <br />
	</form>
	
	<!-- Register / Activate button -->
	<div id="register-license-button-section">
		<input type="submit" value="Register / Activate"
			id="noLicenseFormSubmitButton" name="noLicenseFormSubmitButton"
			class="button">
	</div>

	<!-- Confirm activation dialog  -->
	<div id="confirmLicenseDialogMask"></div>
	<div id="confirmLicenseDialog">
		<div class="dialog-header">
			<a title="Close" class="close-button">x</a>
		</div>
		<p>The activation process involves binding your license key to
			this license server deployment.</p>
		<p>Once the process is complete you cannot activate the license
			key with another license server deployment.</p>
		<p>If your license is already activated, it will not be changed
			and will be used as is.</p>
		<p>During this process, the activation signature, provided license key, and any configured public URL are sent to oxygenxml.com.</p>

		<input type="submit" value="Confirm Activation"
			name="noLicenseFormConfirmButton" id="noLicenseFormConfirmButton"
			class="button">
	</div>
</body>
<script type="text/javascript" src="js/serverUrlActivationConfiguration.js"></script>
</html>