/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.activation.sysinfo.encryptor;

import java.util.StringTokenizer;

public final class Crypto {
    private static final int MINIMUM_PASSWORD_LENGTH = 20;
    private static final char PADDING_SEPARATOR = '.';
    private static final char[] CRIPT_CHARS = new char[]{'\u00f6', '%', '\u0178', '\u00a2', '\u00b6', '&', '\u00f8', '\u00f1', '#', '\u00be', '^', 'w', '\u00a3', '\u00a4', '\u00c8', '\u00e6', '\u00e0', '\u00de', '\u00df'};
    private static final int CONST = 2;

    private Crypto() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    private static boolean isCriptChar(char c) {
        boolean found = false;
        for (int k = 0; k < CRIPT_CHARS.length && !found; ++k) {
            found = CRIPT_CHARS[k] == c;
        }
        return found;
    }

    static String applyEncryptionAlg(String key, String toCrypt) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < toCrypt.length(); ++i) {
            result.append(toCrypt.charAt(i) + key.charAt(i % key.length()) + 2).append(';');
        }
        return result.toString();
    }

    public static String crypt(String key, String toCrypt) {
        int size = String.valueOf(toCrypt).length() + 1;
        StringBuilder toCryptBuilder = new StringBuilder(Math.max(size, 20));
        toCryptBuilder.append(toCrypt).append('.');
        if (size < 20) {
            int i = 0;
            while (toCryptBuilder.length() < 20) {
                char paddingChar = CRIPT_CHARS[i];
                if (paddingChar != '.') {
                    toCryptBuilder.append(paddingChar);
                }
                ++i;
            }
        }
        toCrypt = toCryptBuilder.toString();
        return Crypto.applyEncryptionAlg(key, toCrypt);
    }

    public static String decrypt(String key, String toDecrypt, boolean checkPaddingSeparator) {
        String toReturn = null;
        try {
            StringBuilder result = Crypto.decrypt(toDecrypt, key);
            int index = result.lastIndexOf(String.valueOf('.'));
            if (index > -1) {
                boolean keepMessage = true;
                if (checkPaddingSeparator) {
                    for (int j = index + 1; j < result.length() && keepMessage; ++j) {
                        keepMessage = Crypto.isCriptChar(result.charAt(j));
                    }
                }
                if (keepMessage) {
                    result.setLength(index);
                    toReturn = result.toString();
                }
            } else if (!checkPaddingSeparator) {
                toReturn = result.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return toReturn;
    }

    private static StringBuilder decrypt(String toDecrypt, String key) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        StringTokenizer tokenizer = new StringTokenizer(toDecrypt, ";");
        while (tokenizer.hasMoreTokens()) {
            String element = tokenizer.nextToken();
            int e = Integer.parseInt(element);
            result.append((char)(e - 2 - key.charAt(i % key.length())));
            ++i;
        }
        return result;
    }
}

