/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.activation.sysinfo.collector;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaApiPhysicalAddresses {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JavaApiPhysicalAddresses.class.getName());

    protected String formatMac(byte[] mac) {
        if (mac == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < mac.length; ++i) {
            sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
        }
        return sb.toString();
    }

    public String collectPhysicalAddresses(boolean includeTunnel) throws SocketException {
        Enumeration<NetworkInterface> e = this.getNetworkInterfaces();
        TreeSet<String> macs = new TreeSet<String>();
        while (e.hasMoreElements()) {
            String mac = this.formatMac(this.getHardwareAddresses(e.nextElement(), includeTunnel));
            if (mac == null) continue;
            macs.add(mac);
        }
        if (includeTunnel) {
            macs.add("00-00-00-00-00-00-00-E0");
        }
        LOGGER.debug("Macs: {}", macs);
        return ((Object)macs).toString();
    }

    protected byte[] getHardwareAddresses(NetworkInterface ni, boolean includeTunnel) throws SocketException {
        byte[] toReturn = null;
        if (!ni.isLoopback() && !ni.isVirtual()) {
            if (!includeTunnel && ni.isPointToPoint()) {
                return null;
            }
            toReturn = ni.getHardwareAddress();
        }
        return toReturn;
    }

    protected Enumeration<NetworkInterface> getNetworkInterfaces() throws SocketException {
        return NetworkInterface.getNetworkInterfaces();
    }
}

