/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.activation.sysinfo;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.activation.sysinfo.collector.JavaApiPhysicalAddresses;
import ro.sync.activation.sysinfo.encryptor.Crypto;
import ro.sync.activation.sysinfo.hashgen.MD5HashGenerator;

public final class Guide {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Guide.class.getName());

    private Guide() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static String hash(String stringToHash, String key) {
        String hashedString = null;
        if (stringToHash != null && !stringToHash.trim().isEmpty()) {
            String encryptedServerUrl = Crypto.crypt(key, stringToHash);
            try {
                hashedString = MD5HashGenerator.generateHash(encryptedServerUrl);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException();
            }
        }
        return hashedString;
    }

    private static String getHardwareSignatureOverride() {
        Object physicalAddressProvider;
        Class<?> physicalAddressesProviderOverrideClass;
        try {
            physicalAddressesProviderOverrideClass = Class.forName("ro.sync.activation.sysinfo.collector.PhysicalAddressesProviderOverride");
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("Class not found");
            return null;
        }
        try {
            physicalAddressProvider = physicalAddressesProviderOverrideClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.debug("Error creating instance of the class", (Throwable)e);
            return null;
        }
        try {
            String addr = (String)physicalAddressesProviderOverrideClass.getMethod("collectPhysicalAddresses", new Class[0]).invoke(physicalAddressProvider, new Object[0]);
            return addr.toUpperCase(Locale.US);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.debug("Error invoking method", (Throwable)e);
            return null;
        }
    }

    public static String getMacHash(String encryptionKey, boolean includeTunnel) throws IOException {
        String hardwareSignature = Guide.getHardwareSignatureOverride();
        if (hardwareSignature == null) {
            hardwareSignature = new JavaApiPhysicalAddresses().collectPhysicalAddresses(includeTunnel);
        }
        return Guide.hash(hardwareSignature, encryptionKey);
    }
}

