/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.topic.table.simpletable;

import java.util.Arrays;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.commons.table.operations.InsertRowOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.InsertTableCellsContentConstants;
import ro.sync.ecss.extensions.dita.topic.table.simpletable.DITASimpleTableDocumentTypeHelper;
import ro.sync.ecss.extensions.dita.topic.table.simpletable.SimpleTableConstants;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class InsertRowOperation
extends InsertRowOperationBase
implements SimpleTableConstants,
InsertTableCellsContentConstants {
    protected String cellContent;

    public InsertRowOperation() {
        super(new DITASimpleTableDocumentTypeHelper());
    }

    @Override
    protected void doOperationInternal(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object cellFragmentObj = args.getArgumentValue("cellFragment");
        if (cellFragmentObj instanceof String) {
            this.cellContent = (String)cellFragmentObj;
        }
        if ("".equals(this.cellContent)) {
            this.cellContent = null;
        }
        super.doOperationInternal(authorAccess, args);
    }

    @Override
    protected String getCellElementName(AuthorElement tableElement, int columnIndex) {
        String cellElementName = null;
        String tableName = tableElement.getLocalName();
        if ("simpletable".equals(tableName)) {
            cellElementName = "stentry";
        } else if ("choicetable".equals(tableName)) {
            if (columnIndex == 0) {
                cellElementName = "choption";
            } else if (columnIndex == 1) {
                cellElementName = "chdesc";
            }
        } else if ("properties".equals(tableName)) {
            switch (columnIndex) {
                case 0: {
                    cellElementName = "proptype";
                    break;
                }
                case 1: {
                    cellElementName = "propvalue";
                    break;
                }
                case 2: {
                    cellElementName = "propdesc";
                }
            }
        }
        return cellElementName;
    }

    @Override
    protected String getRowElementName(AuthorElement tableElement) {
        String rowElementName = null;
        String tableName = tableElement.getLocalName();
        if ("simpletable".equals(tableName)) {
            rowElementName = "strow";
        } else if ("choicetable".equals(tableName)) {
            rowElementName = "chrow";
        } else if ("properties".equals(tableName)) {
            rowElementName = "property";
        }
        return rowElementName;
    }

    @Override
    protected String getDefaultContentForEmptyCells() {
        return this.cellContent;
    }

    @Override
    protected ArgumentDescriptor[] getOperationArguments() {
        ArgumentDescriptor[] arguments = null;
        ArgumentDescriptor[] args = super.getOperationArguments();
        if (args != null) {
            arguments = Arrays.copyOf(args, args.length + 1);
            arguments[args.length] = CELL_FRAGMENT_ARGUMENT;
        } else {
            arguments = CELL_FRAGMENT_ARGUMENT_IN_ARRAY;
        }
        return arguments;
    }
}

